/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.AnnotationConfigPage;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.AxisConfigPage;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.GraphConfigPage;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.ITraceConfigPage;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.TraceConfigPage;
import org.eclipse.nebula.visualization.internal.xygraph.undo.XYGraphConfigCommand;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class XYGraphConfigDialog
extends Dialog {
    private static final int MAX_CONFIG_PAGE_COUNT = 50;
    private GraphConfigPage graphConfigPage;
    private List<AnnotationConfigPage> annotationConfigPageList;
    private List<AxisConfigPage> axisConfigPageList;
    private List<ITraceConfigPage> traceConfigPageList;
    private Combo traceCombo;
    private Combo axisCombo;
    private Combo annotationsCombo;
    private IXYGraph xyGraph;
    private XYGraphConfigCommand command;
    private boolean changed = false;

    public XYGraphConfigDialog(Shell parentShell, IXYGraph xyGraph) {
        super(parentShell);
        this.xyGraph = xyGraph;
        this.graphConfigPage = new GraphConfigPage(this.xyGraph);
        this.annotationConfigPageList = new ArrayList<AnnotationConfigPage>();
        this.axisConfigPageList = new ArrayList<AxisConfigPage>();
        this.traceConfigPageList = new ArrayList<ITraceConfigPage>();
        this.command = new XYGraphConfigCommand(xyGraph);
        this.command.savePreviousStates();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Configure Graph Settings");
    }

    protected Control createDialogArea(Composite parent) {
        return this.createDialogArea(parent, true);
    }

    protected Control createDialogArea(Composite parent, boolean enableAxisRanges) {
        Composite parent_composite = (Composite)super.createDialogArea(parent);
        parent_composite.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(parent_composite, 0);
        Composite graphTabComposite = new Composite((Composite)tabFolder, 0);
        this.graphConfigPage.createPage(graphTabComposite);
        TabItem graphConfigTab = new TabItem(tabFolder, 0);
        graphConfigTab.setText("Graph");
        graphConfigTab.setToolTipText("Configure General Graph Settings");
        graphConfigTab.setControl((Control)graphTabComposite);
        Composite axisTabComposite = new Composite((Composite)tabFolder, 0);
        axisTabComposite.setLayout((Layout)new GridLayout(1, false));
        TabItem axisConfigTab = new TabItem(tabFolder, 0);
        axisConfigTab.setText("Axes");
        axisConfigTab.setToolTipText("Configure Axes Settings");
        axisConfigTab.setControl((Control)axisTabComposite);
        if (this.xyGraph.getAxisList().size() > 50) {
            this.addMaxWarningMessage(axisTabComposite, "axes");
        }
        Group axisSelectGroup = new Group(axisTabComposite, 0);
        axisSelectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        axisSelectGroup.setText("Select Axis");
        axisSelectGroup.setLayout((Layout)new GridLayout(1, false));
        this.axisCombo = new Combo((Composite)axisSelectGroup, 12);
        this.axisCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        int count = 0;
        for (Axis axis : this.xyGraph.getAxisList()) {
            if (++count > 50) break;
            this.axisCombo.add(axis.getTitle() + (axis.isHorizontal() ? "(X-Axis)" : "(Y-Axis)"));
        }
        this.axisCombo.select(0);
        final Composite axisConfigComposite = new Composite(axisTabComposite, 0);
        axisConfigComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        final StackLayout axisStackLayout = new StackLayout();
        axisConfigComposite.setLayout((Layout)axisStackLayout);
        count = 0;
        for (Axis axis : this.xyGraph.getAxisList()) {
            if (++count > 50) break;
            Group axisConfigGroup = new Group(axisConfigComposite, 0);
            axisConfigGroup.setText("Change Settings");
            axisConfigGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            AxisConfigPage axisConfigPage = new AxisConfigPage(this.xyGraph, axis, enableAxisRanges);
            this.axisConfigPageList.add(axisConfigPage);
            axisConfigPage.createPage((Composite)axisConfigGroup);
        }
        axisStackLayout.topControl = this.axisConfigPageList.get(0).getComposite();
        this.axisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                axisStackLayout.topControl = XYGraphConfigDialog.this.axisConfigPageList.get(XYGraphConfigDialog.this.axisCombo.getSelectionIndex()).getComposite();
                axisConfigComposite.layout(true, true);
            }
        });
        if (this.xyGraph.getPlotArea().getTraceList().size() > 0) {
            Composite traceTabComposite = new Composite((Composite)tabFolder, 0);
            traceTabComposite.setLayout((Layout)new GridLayout(1, false));
            TabItem traceConfigTab = new TabItem(tabFolder, 0);
            traceConfigTab.setText("Traces");
            traceConfigTab.setToolTipText("Configure Traces Settings");
            traceConfigTab.setControl((Control)traceTabComposite);
            if (this.xyGraph.getPlotArea().getTraceList().size() > 50) {
                this.addMaxWarningMessage(traceTabComposite, "traces");
            }
            Group traceSelectGroup = new Group(traceTabComposite, 0);
            traceSelectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            traceSelectGroup.setText("Select Trace");
            traceSelectGroup.setLayout((Layout)new GridLayout(1, false));
            this.traceCombo = new Combo((Composite)traceSelectGroup, 12);
            this.traceCombo.setLayoutData((Object)new GridData(4, 0, true, false));
            count = 0;
            for (Trace trace : this.xyGraph.getPlotArea().getTraceList()) {
                if (++count > 50) break;
                this.traceCombo.add(trace.getName());
            }
            this.traceCombo.select(0);
            final Composite traceConfigComposite = new Composite(traceTabComposite, 0);
            traceConfigComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            final StackLayout traceStackLayout = new StackLayout();
            traceConfigComposite.setLayout((Layout)traceStackLayout);
            count = 0;
            for (Trace trace : this.xyGraph.getPlotArea().getTraceList()) {
                if (++count > 50) break;
                Group traceConfigGroup = new Group(traceConfigComposite, 0);
                traceConfigGroup.setText("Change Settings");
                traceConfigGroup.setLayoutData((Object)new GridData(4, 4, true, true));
                ITraceConfigPage traceConfigPage = this.createTraceConfigPage(trace);
                this.traceConfigPageList.add(traceConfigPage);
                traceConfigPage.createPage((Composite)traceConfigGroup);
            }
            traceStackLayout.topControl = this.traceConfigPageList.get(0).getComposite();
            this.traceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    traceStackLayout.topControl = XYGraphConfigDialog.this.traceConfigPageList.get(XYGraphConfigDialog.this.traceCombo.getSelectionIndex()).getComposite();
                    traceConfigComposite.layout(true, true);
                }
            });
        }
        if (this.xyGraph.getPlotArea().getAnnotationList().size() > 0) {
            Composite annoTabComposite = new Composite((Composite)tabFolder, 0);
            annoTabComposite.setLayout((Layout)new GridLayout(1, false));
            TabItem annoConfigTab = new TabItem(tabFolder, 0);
            annoConfigTab.setText("Annotations");
            annoConfigTab.setToolTipText("Configure Annotation Settings");
            annoConfigTab.setControl((Control)annoTabComposite);
            if (this.xyGraph.getPlotArea().getAnnotationList().size() > 50) {
                this.addMaxWarningMessage(annoTabComposite, "annotations");
            }
            Group annoSelectGroup = new Group(annoTabComposite, 0);
            annoSelectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            annoSelectGroup.setText("Select Annotation");
            annoSelectGroup.setLayout((Layout)new GridLayout(1, false));
            this.annotationsCombo = new Combo((Composite)annoSelectGroup, 12);
            this.annotationsCombo.setLayoutData((Object)new GridData(4, 0, true, false));
            count = 0;
            for (Annotation annotation : this.xyGraph.getPlotArea().getAnnotationList()) {
                if (++count > 50) break;
                this.annotationsCombo.add(annotation.getName());
            }
            this.annotationsCombo.select(0);
            final Composite annoConfigComposite = new Composite(annoTabComposite, 0);
            annoConfigComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            final StackLayout stackLayout = new StackLayout();
            annoConfigComposite.setLayout((Layout)stackLayout);
            count = 0;
            for (Annotation annotation : this.xyGraph.getPlotArea().getAnnotationList()) {
                if (++count > 50) break;
                Group annoConfigGroup = new Group(annoConfigComposite, 0);
                annoConfigGroup.setText("Change Settings");
                annoConfigGroup.setLayoutData((Object)new GridData(4, 4, true, true));
                AnnotationConfigPage annotationConfigPage = new AnnotationConfigPage(this.xyGraph, annotation);
                this.annotationConfigPageList.add(annotationConfigPage);
                annotationConfigPage.createPage((Composite)annoConfigGroup);
            }
            stackLayout.topControl = this.annotationConfigPageList.get(0).getComposite();
            this.annotationsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    stackLayout.topControl = XYGraphConfigDialog.this.annotationConfigPageList.get(XYGraphConfigDialog.this.annotationsCombo.getSelectionIndex()).getComposite();
                    annoConfigComposite.layout(true, true);
                }
            });
        }
        return parent_composite;
    }

    protected ITraceConfigPage createTraceConfigPage(Trace trace) {
        return new TraceConfigPage(this.xyGraph, trace);
    }

    private void addMaxWarningMessage(Composite composite, String type) {
        CLabel warning = new CLabel(composite, 0);
        warning.setText("There are too many " + type + " to edit");
        warning.setToolTipText("Currently only the first 50 " + type + " can have their properties manually edited.\nThis is due to a limitation with the current widget design on the configure form.\nPlease see Bug 514179 for more details.");
        warning.setLayoutData((Object)new GridData(4, 4, true, false));
        warning.setImage(XYGraphMediaFactory.getInstance().getImage("images/warning.png"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText("Apply");
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XYGraphConfigDialog.this.applyChanges();
            }
        });
        super.createButtonsForButtonBar(parent);
        Shell shell = parent.getShell();
        if (shell != null) {
            shell.setDefaultButton(button);
        }
    }

    protected void okPressed() {
        this.applyChanges();
        this.command.saveAfterStates();
        this.xyGraph.getOperationsManager().addCommand(this.command);
        super.okPressed();
    }

    protected void applyChanges() {
        this.changed = true;
        this.graphConfigPage.applyChanges();
        for (AxisConfigPage axisConfigPage : this.axisConfigPageList) {
            axisConfigPage.applyChanges();
        }
        for (ITraceConfigPage traceConfigPage : this.traceConfigPageList) {
            traceConfigPage.applyChanges();
        }
        for (AnnotationConfigPage annotationConfigPage : this.annotationConfigPageList) {
            annotationConfigPage.applyChanges();
        }
        this.xyGraph.fireConfigChanged();
    }

    protected void cancelPressed() {
        if (this.changed) {
            this.command.saveAfterStates();
            this.xyGraph.getOperationsManager().addCommand(this.command);
        }
        super.cancelPressed();
    }

    public Combo getTraceCombo() {
        return this.traceCombo;
    }

    public Combo getAxisCombo() {
        return this.axisCombo;
    }

    public Combo getAnnotationsCombo() {
        return this.annotationsCombo;
    }

    public List<AnnotationConfigPage> getAnnotationConfigPageList() {
        return this.annotationConfigPageList;
    }

    public List<AxisConfigPage> getAxisConfigPageList() {
        return this.axisConfigPageList;
    }

    public List<ITraceConfigPage> getTraceConfigPageList() {
        return this.traceConfigPageList;
    }

    public IXYGraph getXYGraph() {
        return this.xyGraph;
    }

    public XYGraphConfigCommand getCommand() {
        return this.command;
    }

    public void setCommand(XYGraphConfigCommand command) {
        this.command = command;
    }
}

