/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.datadefinition.IManualValueChangeListener;
import org.eclipse.nebula.visualization.widgets.figureparts.AlphaLabel;
import org.eclipse.nebula.visualization.widgets.figures.AbstractLinearMarkedFigure;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.widgets.util.RepeatFiringBehavior;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaledMarker;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ScaledSliderFigure
extends AbstractLinearMarkedFigure {
    private Color fillColor = BLUE_COLOR;
    private Color fillBackgroundColor = GRAY_COLOR;
    private Color thumbColor = XYGraphMediaFactory.getInstance().getColor(new RGB(172, 172, 172));
    private boolean effect3D = true;
    private boolean horizontal = false;
    private static final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private static final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
    private static final Color GREEN_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GREEN);
    private static final Color BLUE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE);
    private static final Color LABEL_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(255, 255, 150));
    private static final int DISABLED_ALPHA = 100;
    private Track track;
    private Thumb thumb;
    private AlphaLabel label;
    private double stepIncrement = 1.0;
    private double pageIncrement = 10.0;
    private boolean drawFocus = true;
    private List<IManualValueChangeListener> listeners = new ArrayList<IManualValueChangeListener>();

    public ScaledSliderFigure() {
        this.scale.setScaleLineVisible(false);
        this.scale.setTickLabelSide(AbstractScale.LabelSide.Secondary);
        if (this.horizontal) {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.HORIZONTAL);
            this.scale.setTickLabelSide(AbstractScale.LabelSide.Primary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Secondary);
        } else {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.VERTICAL);
            this.scale.setTickLabelSide(AbstractScale.LabelSide.Secondary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Primary);
        }
        this.track = new Track();
        this.thumb = new Thumb();
        this.label = new AlphaLabel();
        this.label.setBackgroundColor(LABEL_COLOR);
        this.label.setBorder((Border)new LineBorder(GRAY_COLOR));
        this.label.setVisible(false);
        this.setLayoutManager((LayoutManager)new XSliderLayout());
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.marker, "markers");
        this.add((IFigure)this.track, "track");
        this.add((IFigure)this.thumb, "thumb");
        this.add((IFigure)this.label, "label");
        this.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                ScaledSliderFigure.this.revalidate();
            }
        });
        this.setRequestFocusEnabled(true);
        this.setFocusTraversable(true);
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
                if (ke.keycode == 0x1000002 && !ScaledSliderFigure.this.horizontal || ke.keycode == 0x1000003 && ScaledSliderFigure.this.horizontal) {
                    ScaledSliderFigure.this.stepDown();
                } else if (ke.keycode == 0x1000001 && !ScaledSliderFigure.this.horizontal || ke.keycode == 0x1000004 && ScaledSliderFigure.this.horizontal) {
                    ScaledSliderFigure.this.stepUp();
                } else if (ke.keycode == 0x1000005) {
                    ScaledSliderFigure.this.pageUp();
                } else if (ke.keycode == 0x1000006) {
                    ScaledSliderFigure.this.pageDown();
                }
            }

            public void keyReleased(KeyEvent ke) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                ScaledSliderFigure.this.repaint();
            }

            public void focusLost(FocusEvent fe) {
                ScaledSliderFigure.this.repaint();
            }
        });
    }

    public void addManualValueChangeListener(IManualValueChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeManualValueChangeListener(IManualValueChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private double calcValueChange(Dimension difference, double oldValue) {
        double change;
        double dragRange = ((LinearScale)this.scale).getTickLength();
        if (this.scale.isLogScaleEnabled()) {
            double c = dragRange / (Math.log10(this.scale.getRange().getUpper()) - Math.log10(this.scale.getRange().getLower()));
            change = this.horizontal ? oldValue * (Math.pow(10.0, (double)difference.width / c) - 1.0) : oldValue * (Math.pow(10.0, (double)(-difference.height) / c) - 1.0);
        } else {
            change = this.horizontal ? (this.scale.getRange().getUpper() - this.scale.getRange().getLower()) * (double)difference.width / dragRange : -(this.scale.getRange().getUpper() - this.scale.getRange().getLower()) * (double)difference.height / dragRange;
        }
        return change;
    }

    private void fireManualValueChange(double newManualValue) {
        for (IManualValueChangeListener l : this.listeners) {
            l.manualValueChanged(newManualValue);
        }
    }

    public Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public double getPageIncrement() {
        return this.pageIncrement;
    }

    public double getStepIncrement() {
        return this.stepIncrement;
    }

    public Color getThumbColor() {
        return this.thumbColor;
    }

    public boolean isEffect3D() {
        return this.effect3D;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void revalidate() {
        this.invalidate();
        this.getUpdateManager().addInvalidFigure((IFigure)this);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void manualSetValue(double value) {
        this.setValue(this.getCoercedValue(value));
    }

    public void pageDown() {
        this.manualSetValue(this.getValue() - this.pageIncrement);
        this.fireManualValueChange(this.getValue());
    }

    public void pageUp() {
        this.manualSetValue(this.getValue() + this.pageIncrement);
        this.fireManualValueChange(this.getValue());
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (this.hasFocus() && this.drawFocus) {
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setBackgroundColor(ColorConstants.white);
            Rectangle area = this.getClientArea();
            graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
        }
        if (!this.isEnabled()) {
            graphics.setAlpha(100);
            graphics.setBackgroundColor(GRAY_COLOR);
            graphics.fillRectangle(this.bounds);
        }
    }

    public void setEffect3D(boolean effect3D) {
        if (this.effect3D == effect3D) {
            return;
        }
        this.effect3D = effect3D;
        this.repaint();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.repaint();
    }

    public void setFillBackgroundColor(Color fillBackgroundColor) {
        if (this.fillBackgroundColor != null && this.fillBackgroundColor.equals((Object)fillBackgroundColor)) {
            return;
        }
        this.fillBackgroundColor = fillBackgroundColor;
        this.repaint();
    }

    public void setFillColor(Color fillColor) {
        if (this.fillColor != null && this.fillColor.equals((Object)fillColor)) {
            return;
        }
        this.fillColor = fillColor;
        this.repaint();
    }

    public void setHorizontal(boolean horizontal) {
        if (this.horizontal == horizontal) {
            return;
        }
        this.horizontal = horizontal;
        if (horizontal) {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.HORIZONTAL);
            this.scale.setTickLabelSide(AbstractScale.LabelSide.Primary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Secondary);
        } else {
            ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.VERTICAL);
            this.scale.setTickLabelSide(AbstractScale.LabelSide.Secondary);
            this.marker.setLabelSide(AbstractScale.LabelSide.Primary);
        }
        this.revalidate();
    }

    public void setPageIncrement(double pageIncrement) {
        this.pageIncrement = pageIncrement;
    }

    public void setStepIncrement(double stepIncrement) {
        this.stepIncrement = stepIncrement;
    }

    public void setThumbColor(Color thumbColor) {
        if (this.thumbColor != null && this.thumbColor.equals((Object)thumbColor)) {
            return;
        }
        this.thumbColor = thumbColor;
        this.repaint();
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.revalidate();
    }

    public void stepDown() {
        this.manualSetValue(this.getValue() - this.stepIncrement);
        this.fireManualValueChange(this.getValue());
    }

    public void stepUp() {
        this.manualSetValue(this.getValue() + this.stepIncrement);
        this.fireManualValueChange(this.getValue());
    }

    class Thumb
    extends Polygon {
        public static final int LENGTH = 20;
        public static final int BREADTH = 11;
        public final PointList horizontalThumbPointList;
        public final PointList verticalThumbPointList;
        private Color temp;

        public Thumb() {
            int[] nArray = new int[10];
            nArray[3] = 11;
            nArray[4] = 16;
            nArray[5] = 11;
            nArray[6] = 20;
            nArray[7] = 5;
            nArray[8] = 16;
            this.horizontalThumbPointList = new PointList(nArray);
            int[] nArray2 = new int[10];
            nArray2[3] = 16;
            nArray2[4] = 5;
            nArray2[5] = 20;
            nArray2[6] = 11;
            nArray2[7] = 16;
            nArray2[8] = 11;
            this.verticalThumbPointList = new PointList(nArray2);
            this.setOutline(true);
            this.setFill(true);
            this.setCursor(Cursors.HAND);
            this.setForegroundColor(GRAY_COLOR);
            this.setLineWidth(1);
            ThumbDragger thumbDragger = new ThumbDragger();
            this.addMouseMotionListener((MouseMotionListener)thumbDragger);
            this.addMouseListener(thumbDragger);
        }

        protected void fillShape(Graphics g) {
            g.setAntialias(1);
            g.setClip(new Rectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height));
            g.setBackgroundColor(WHITE_COLOR);
            super.fillShape(g);
            Point leftPoint = this.getPoints().getPoint(0);
            Point rightPoint = ScaledSliderFigure.this.horizontal ? this.getPoints().getPoint(4) : this.getPoints().getPoint(1);
            Pattern thumbPattern = null;
            boolean support3D = GraphicsUtil.testPatternSupported(g);
            if (ScaledSliderFigure.this.effect3D && support3D) {
                thumbPattern = GraphicsUtil.createScaledPattern(g, (Device)Display.getCurrent(), leftPoint.x, leftPoint.y, rightPoint.x, rightPoint.y, WHITE_COLOR, 0, ScaledSliderFigure.this.thumbColor, 255);
                g.setBackgroundPattern(thumbPattern);
            } else {
                g.setBackgroundColor(ScaledSliderFigure.this.thumbColor);
            }
            g.fillPolygon(this.getPoints());
            if (ScaledSliderFigure.this.effect3D && support3D) {
                thumbPattern.dispose();
            }
        }

        class ThumbDragger
        extends MouseMotionListener.Stub
        implements MouseListener {
            protected Point start;
            protected boolean armed;

            ThumbDragger() {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mouseDragged(MouseEvent me) {
                if (!this.armed) {
                    return;
                }
                Dimension difference = me.getLocation().getDifference(this.start);
                double valueChange = ScaledSliderFigure.this.calcValueChange(difference, ((Thumb)Thumb.this).ScaledSliderFigure.this.value);
                double oldValue = ((Thumb)Thumb.this).ScaledSliderFigure.this.value;
                if (((Thumb)Thumb.this).ScaledSliderFigure.this.stepIncrement <= 0.0 || Math.abs(valueChange) > ((Thumb)Thumb.this).ScaledSliderFigure.this.stepIncrement / 2.0) {
                    if (((Thumb)Thumb.this).ScaledSliderFigure.this.stepIncrement > 0.0) {
                        ScaledSliderFigure.this.manualSetValue(((Thumb)Thumb.this).ScaledSliderFigure.this.value + ((Thumb)Thumb.this).ScaledSliderFigure.this.stepIncrement * (double)Math.round(valueChange / ((Thumb)Thumb.this).ScaledSliderFigure.this.stepIncrement));
                    } else {
                        ScaledSliderFigure.this.manualSetValue(((Thumb)Thumb.this).ScaledSliderFigure.this.value + valueChange);
                    }
                    ((Thumb)Thumb.this).ScaledSliderFigure.this.label.setVisible(true);
                    double valuePosition = ((LinearScale)((Thumb)Thumb.this).ScaledSliderFigure.this.scale).getValuePosition(ScaledSliderFigure.this.getCoercedValue(), false);
                    if (((Thumb)Thumb.this).ScaledSliderFigure.this.value != oldValue) {
                        ScaledSliderFigure.this.fireManualValueChange(((Thumb)Thumb.this).ScaledSliderFigure.this.value);
                    }
                    this.start = new Point(((Thumb)Thumb.this).ScaledSliderFigure.this.horizontal ? valuePosition : 0.0, ((Thumb)Thumb.this).ScaledSliderFigure.this.horizontal ? 0.0 : valuePosition);
                }
                me.consume();
            }

            public void mouseEntered(MouseEvent me) {
                Thumb.this.temp = ((Thumb)Thumb.this).ScaledSliderFigure.this.thumbColor;
                ((Thumb)Thumb.this).ScaledSliderFigure.this.thumbColor = GREEN_COLOR;
                Thumb.this.repaint();
            }

            public void mouseExited(MouseEvent me) {
                ((Thumb)Thumb.this).ScaledSliderFigure.this.thumbColor = Thumb.this.temp;
                ((Thumb)Thumb.this).ScaledSliderFigure.this.label.setVisible(false);
                Thumb.this.repaint();
            }

            public void mousePressed(MouseEvent me) {
                if (me.button != 1) {
                    return;
                }
                this.armed = true;
                double valuePosition = ((LinearScale)((Thumb)Thumb.this).ScaledSliderFigure.this.scale).getValuePosition(ScaledSliderFigure.this.getCoercedValue(), false);
                this.start = new Point(((Thumb)Thumb.this).ScaledSliderFigure.this.horizontal ? valuePosition : 0.0, ((Thumb)Thumb.this).ScaledSliderFigure.this.horizontal ? 0.0 : valuePosition);
                ((Thumb)Thumb.this).ScaledSliderFigure.this.label.setVisible(true);
                if (!ScaledSliderFigure.this.hasFocus()) {
                    ScaledSliderFigure.this.requestFocus();
                }
                me.consume();
            }

            public void mouseReleased(MouseEvent me) {
                if (me.button != 1) {
                    return;
                }
                if (!this.armed) {
                    return;
                }
                this.armed = false;
                me.consume();
            }
        }
    }

    class Track
    extends RectangleFigure {
        public static final int TRACK_BREADTH = 6;
        private RepeatFiringBehavior behavior = new RepeatFiringBehavior();
        private double pressedValue;
        private boolean pageUp;

        public Track() {
            this.setOutline(false);
            this.setForegroundColor(GRAY_COLOR);
            this.setCursor(Cursors.HAND);
            this.behavior.setRunTask(new Runnable(){

                @Override
                public void run() {
                    if (Track.this.pageUp) {
                        if (ScaledSliderFigure.this.getValue() >= Track.this.pressedValue) {
                            Track.this.behavior.suspend();
                        } else {
                            ScaledSliderFigure.this.pageUp();
                        }
                    } else if (ScaledSliderFigure.this.getValue() <= Track.this.pressedValue) {
                        Track.this.behavior.suspend();
                    } else {
                        ScaledSliderFigure.this.pageDown();
                    }
                }
            });
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    if (me.button != 1) {
                        return;
                    }
                    Point start = me.getLocation();
                    if (((Track)Track.this).ScaledSliderFigure.this.horizontal) {
                        start.x += ((Track)Track.this).ScaledSliderFigure.this.thumb.getBounds().width / 2;
                    } else {
                        start.y += ((Track)Track.this).ScaledSliderFigure.this.thumb.getBounds().height / 2;
                    }
                    Track.this.pressedValue = ((LinearScale)((Track)Track.this).ScaledSliderFigure.this.scale).getPositionValue(((Track)Track.this).ScaledSliderFigure.this.horizontal ? start.x : start.y, false);
                    Track.this.pageUp = Track.this.pressedValue > ScaledSliderFigure.this.getValue();
                    Track.this.behavior.pressed();
                    if (!ScaledSliderFigure.this.hasFocus()) {
                        ScaledSliderFigure.this.requestFocus();
                    }
                    me.consume();
                }

                public void mouseReleased(MouseEvent me) {
                    if (me.button != 1) {
                        return;
                    }
                    Track.this.behavior.released();
                }
            });
        }

        protected void fillShape(Graphics graphics) {
            graphics.setAntialias(1);
            int valuePosition = ((LinearScale)ScaledSliderFigure.this.scale).getValuePosition(ScaledSliderFigure.this.getCoercedValue(), false);
            boolean support3D = GraphicsUtil.testPatternSupported(graphics);
            if (ScaledSliderFigure.this.effect3D && support3D) {
                graphics.setBackgroundColor(ScaledSliderFigure.this.fillBackgroundColor);
                super.fillShape(graphics);
                Pattern backGroundPattern = ScaledSliderFigure.this.horizontal ? GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height, WHITE_COLOR, 255, ScaledSliderFigure.this.fillBackgroundColor, 0) : GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y, WHITE_COLOR, 255, ScaledSliderFigure.this.fillBackgroundColor, 0);
                graphics.setBackgroundPattern(backGroundPattern);
                super.fillShape(graphics);
                graphics.setForegroundColor(ScaledSliderFigure.this.fillBackgroundColor);
                this.outlineShape(graphics);
                backGroundPattern.dispose();
                backGroundPattern = ScaledSliderFigure.this.horizontal ? GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height, WHITE_COLOR, 255, ScaledSliderFigure.this.fillColor, 0) : GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y, WHITE_COLOR, 255, ScaledSliderFigure.this.fillColor, 0);
                graphics.setBackgroundColor(ScaledSliderFigure.this.fillColor);
                graphics.setForegroundColor(ScaledSliderFigure.this.fillColor);
                if (ScaledSliderFigure.this.horizontal) {
                    int fillWidth = valuePosition - this.bounds.x;
                    graphics.fillRectangle(new Rectangle(this.bounds.x, this.bounds.y, fillWidth, this.bounds.height));
                    graphics.setBackgroundPattern(backGroundPattern);
                    graphics.fillRectangle(new Rectangle(this.bounds.x, this.bounds.y, fillWidth, this.bounds.height));
                    graphics.drawRectangle(new Rectangle(this.bounds.x + this.lineWidth / 2, this.bounds.y + this.lineWidth / 2, fillWidth - Math.max(1, this.lineWidth), this.bounds.height - Math.max(1, this.lineWidth)));
                } else {
                    int fillHeight = this.bounds.height - (valuePosition - this.bounds.y);
                    graphics.fillRectangle(new Rectangle(this.bounds.x, valuePosition, this.bounds.width, fillHeight));
                    graphics.setBackgroundPattern(backGroundPattern);
                    graphics.fillRectangle(new Rectangle(this.bounds.x, valuePosition, this.bounds.width, fillHeight));
                    graphics.drawRectangle(new Rectangle(this.bounds.x + this.lineWidth / 2, valuePosition + this.lineWidth / 2, this.bounds.width - Math.max(1, this.lineWidth), fillHeight - Math.max(1, this.lineWidth)));
                }
                backGroundPattern.dispose();
            } else {
                graphics.setBackgroundColor(ScaledSliderFigure.this.fillBackgroundColor);
                super.fillShape(graphics);
                graphics.setBackgroundColor(ScaledSliderFigure.this.fillColor);
                if (ScaledSliderFigure.this.horizontal) {
                    graphics.fillRectangle(new Rectangle(this.bounds.x, this.bounds.y, valuePosition - this.bounds.x, this.bounds.height));
                } else {
                    graphics.fillRectangle(new Rectangle(this.bounds.x, valuePosition, this.bounds.width, this.bounds.height - (valuePosition - this.bounds.y)));
                }
            }
        }
    }

    class XSliderLayout
    extends AbstractLayout {
        private static final int GAP_BTW_THUMB_SCALE = 5;
        private static final int ADDITIONAL_MARGIN = 3;
        private static final int LABEL_MARGIN = 3;
        public static final String SCALE = "scale";
        public static final String TRACK = "track";
        public static final String MARKERS = "markers";
        public static final String THUMB = "thumb";
        public static final String LABEL = "label";
        private LinearScale scale;
        private LinearScaledMarker marker;
        private Track track;
        private Thumb thumb;
        private AlphaLabel label;

        XSliderLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(64, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        private void horizontalLayout(IFigure container) {
            Rectangle area = container.getClientArea().getCopy();
            area.x += 3;
            area.width -= 6;
            if (this.scale != null) {
                Dimension scaleSize = new Dimension(area.width, 0);
                if (this.scale.isVisible()) {
                    scaleSize = this.scale.getPreferredSize(area.width, -1);
                }
                this.scale.setBounds(new Rectangle(area.x, area.y + area.height / 2 + 10 + 5, scaleSize.width, scaleSize.height));
            }
            if (this.marker != null && this.marker.isVisible()) {
                Dimension markerSize = this.marker.getPreferredSize();
                this.marker.setBounds(new Rectangle(this.marker.getScale().getBounds().x, area.y + area.height / 2 - markerSize.height - 10 - 5, markerSize.width, markerSize.height));
            }
            if (this.track != null) {
                this.track.setBounds(new Rectangle(this.scale.getValuePosition(this.scale.getRange().getLower(), false) - this.track.getLineWidth(), area.y + area.height / 2 - 3, this.scale.getTickLength() + 2 * this.track.getLineWidth(), 6));
            }
            if (this.thumb != null) {
                PointList newPointList = this.thumb.verticalThumbPointList.getCopy();
                newPointList.translate(this.scale.getValuePosition(ScaledSliderFigure.this.getCoercedValue(), false) - 5, area.y + area.height / 2 - 10 + 1);
                this.thumb.setPoints(newPointList);
            }
            if (this.label != null && this.label.isVisible()) {
                this.setLabel();
            }
        }

        public void layout(IFigure container) {
            if (ScaledSliderFigure.this.horizontal) {
                this.horizontalLayout(container);
            } else {
                this.verticalLayout(container);
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (LinearScale)child;
            } else if (constraint.equals(MARKERS)) {
                this.marker = (LinearScaledMarker)child;
            } else if (constraint.equals(TRACK)) {
                this.track = (Track)child;
            } else if (constraint.equals(THUMB)) {
                this.thumb = (Thumb)child;
            } else if (constraint.equals(LABEL)) {
                this.label = (AlphaLabel)child;
            }
        }

        private void setLabel() {
            String text = ScaledSliderFigure.this.getValueText();
            Dimension textSize = FigureUtilities.getStringExtents((String)text, (Font)this.label.getFont());
            this.label.setText(text);
            if (ScaledSliderFigure.this.horizontal) {
                this.label.setBounds(new Rectangle(this.thumb.getBounds().x + this.thumb.getBounds().width / 2 - (textSize.width + 6) / 2, this.thumb.getBounds().y - textSize.height - 6, textSize.width + 6, textSize.height + 3));
            } else {
                this.label.setBounds(new Rectangle(this.thumb.getBounds().x - textSize.width - 9, this.thumb.getBounds().y + this.thumb.getBounds().height / 2 - (textSize.height + 3) / 2, textSize.width + 6, textSize.height + 3));
            }
        }

        private void verticalLayout(IFigure container) {
            Rectangle area = container.getClientArea();
            if (this.scale != null) {
                Dimension scaleSize = new Dimension(0, area.height);
                if (this.scale.isVisible()) {
                    scaleSize = this.scale.getPreferredSize(-1, area.height);
                }
                this.scale.setBounds(new Rectangle(area.x + area.width / 2 + 10 + 5, area.y, scaleSize.width, scaleSize.height));
            }
            if (this.marker != null && this.marker.isVisible()) {
                Dimension markerSize = this.marker.getPreferredSize();
                this.marker.setBounds(new Rectangle(area.x + area.width / 2 - markerSize.width - 10 - 5, this.marker.getScale().getBounds().y, markerSize.width, markerSize.height));
            }
            if (this.track != null) {
                this.track.setBounds(new Rectangle(area.x + area.width / 2 - 3, this.scale.getValuePosition(this.scale.getRange().getUpper(), false) - this.track.getLineWidth(), 6, this.scale.getTickLength() + 2 * this.track.getLineWidth()));
            }
            if (this.thumb != null) {
                PointList newPointList = this.thumb.horizontalThumbPointList.getCopy();
                newPointList.translate(area.x + area.width / 2 - 10 + 1, this.scale.getValuePosition(ScaledSliderFigure.this.getCoercedValue(), false) - 5);
                this.thumb.setPoints(newPointList);
            }
            if (this.label != null && this.label.isVisible()) {
                this.setLabel();
            }
        }
    }
}

