/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.examples;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.examples.ButtonFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ListenersDialog
extends Dialog {
    private ArrayList selectedEvents;
    private Table table;

    protected ListenersDialog(Shell parentShell) {
        super(parentShell);
    }

    public int open(ArrayList selectedEvents) {
        this.selectedEvents = selectedEvents;
        return this.open();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select Listeners");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite comp2 = new Composite(composite, 0);
        comp2.setLayout((Layout)new GridLayout(2, false));
        this.table = new Table(comp2, 2080);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.table.setLayoutData((Object)gd);
        int i = 0;
        while (i < AbstractExampleTab.eventIds.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(AbstractExampleTab.eventNames[i]);
            item.setData((Object)new Integer(AbstractExampleTab.eventIds[i]));
            for (Integer eventId : this.selectedEvents) {
                if (!eventId.equals(new Integer(AbstractExampleTab.eventIds[i]))) continue;
                item.setChecked(true);
                break;
            }
            ++i;
        }
        Button selAll = ButtonFactory.create(comp2, 8, "Select All", event -> {
            int i = 0;
            while (i < this.table.getItemCount()) {
                this.table.getItem(i).setChecked(true);
                ++i;
            }
        });
        gd = new GridData();
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 1;
        selAll.setLayoutData((Object)gd);
        ButtonFactory.create(comp2, 8, "Deselect All", event -> {
            int i = 0;
            while (i < this.table.getItemCount()) {
                this.table.getItem(i).setChecked(false);
                ++i;
            }
        }).setLayoutData((Object)gd);
        return composite;
    }

    protected void okPressed() {
        this.selectedEvents.clear();
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            if (item.getChecked()) {
                this.selectedEvents.add(item.getData());
            }
            ++i;
        }
        super.okPressed();
    }
}

