/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.starrating;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.starrating.StarRating;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

class Star {
    private static final String SMALL_STAR_MARKED_FOCUS = "mark-focus16.png";
    private static final String SMALL_STAR_MARKED = "mark16.png";
    private static final String SMALL_STAR_FOCUS = "focus16.png";
    private static final String SMALL_STAR = "16.png";
    private static final String BIG_STAR_MARKED_FOCUS = "mark-focus32.png";
    private static final String BIG_STAR_MARKED = "mark32.png";
    private static final String BIG_STAR_FOCUS = "focus32.png";
    private static final String BIG_STAR = "32.png";
    boolean hover;
    boolean marked;
    Rectangle bounds;
    Image defaultImage;
    Image hoverImage;
    Image selectedImage;
    Image selectedHoverImage;
    private StarRating parent;

    Star() {
    }

    void dispose() {
        this.defaultImage.dispose();
        this.hoverImage.dispose();
        this.selectedImage.dispose();
        this.selectedHoverImage.dispose();
    }

    void draw(GC gc, int x, int y) {
        Image image = !this.parent.isEnabled() ? this.defaultImage : (this.marked ? (this.hover ? this.selectedHoverImage : this.selectedImage) : (this.hover ? this.hoverImage : this.defaultImage));
        gc.drawImage(image, x, y);
        this.bounds = new Rectangle(x, y, image.getBounds().width, image.getBounds().height);
    }

    static Star initBig(StarRating parent) {
        Star star = new Star();
        star.parent = parent;
        star.defaultImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/32.png");
        star.hoverImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/focus32.png");
        star.selectedImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/mark32.png");
        star.selectedHoverImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/mark-focus32.png");
        return star;
    }

    static Star initSmall(StarRating parent) {
        Star star = new Star();
        star.parent = parent;
        star.defaultImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/16.png");
        star.hoverImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/focus16.png");
        star.selectedImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/mark16.png");
        star.selectedHoverImage = SWTGraphicUtil.createImageFromFile((String)"images/stars/mark-focus16.png");
        return star;
    }
}

