/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.PatternFilter;

public class XViewerPatternFilter
extends PatternFilter {
    private String text;

    public void setFilterText(String text) {
        this.text = text;
    }

    @Override
    public void setPattern(String patternString) {
        super.setPattern(patternString);
        this.text = patternString == null || patternString.isEmpty() ? null : patternString.toLowerCase();
    }

    @Override
    public boolean isLeafMatch(Viewer viewer, Object element) {
        if (element == null) {
            return true;
        }
        if (this.text == null || this.text.isEmpty()) {
            return true;
        }
        try {
            String name = element.toString();
            if (element instanceof XViewerColumn) {
                XViewerColumn xCol = (XViewerColumn)element;
                name = xCol.getDisplayName();
            } else if (element instanceof CustomizeData) {
                CustomizeData custData = (CustomizeData)element;
                name = custData.getName();
            }
            return name.toLowerCase().contains(this.text);
        }
        catch (Exception ex) {
            System.err.println("Exception matching leaf " + ex.getLocalizedMessage());
            return true;
        }
    }
}

