/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTImageView;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    String text;
    Image image;
    boolean isImage;
    NSTextField textView;
    NSImageView imageView;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    int accessibilityAttributeNames(int id2, int sel) {
        if (this.accessible != null && (this.textView != null && (id2 == this.textView.id || id2 == this.textView.cell().id) || this.imageView != null && (id2 == this.imageView.id || id2 == this.imageView.cell().id))) {
            NSMutableArray extraAttributes = NSMutableArray.arrayWithCapacity(3);
            extraAttributes.addObject(OS.NSAccessibilityHelpAttribute);
            extraAttributes.addObject(OS.NSAccessibilityDescriptionAttribute);
            extraAttributes.addObject(OS.NSAccessibilityTitleAttribute);
            int i = extraAttributes.count() - 1;
            while (i >= 0) {
                NSString attribute = new NSString(extraAttributes.objectAtIndex((int)i).id);
                if (this.accessible.internal_accessibilityAttributeValue(attribute, -1) == null) {
                    extraAttributes.removeObjectAtIndex(i);
                }
                --i;
            }
            if (extraAttributes.count() > 0) {
                int superResult = super.accessibilityAttributeNames(id2, sel);
                NSArray baseAttributes = new NSArray(superResult);
                NSMutableArray mutableAttributes = NSMutableArray.arrayWithCapacity(baseAttributes.count() + 1);
                mutableAttributes.addObjectsFromArray(baseAttributes);
                int i2 = 0;
                while (i2 < extraAttributes.count()) {
                    id currAttribute = extraAttributes.objectAtIndex(i2);
                    if (!mutableAttributes.containsObject(currAttribute)) {
                        mutableAttributes.addObject(currAttribute);
                    }
                    ++i2;
                }
                return mutableAttributes.id;
            }
        }
        return super.accessibilityAttributeNames(id2, sel);
    }

    boolean accessibilityIsIgnored(int id2, int sel) {
        if (id2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    void addRelation(Control control) {
        if (!control.isDescribedByLabel()) {
            return;
        }
        if (this.textView != null) {
            NSControl viewAsControl;
            NSObject accessibleElement = control.focusView();
            if (accessibleElement instanceof NSControl && (viewAsControl = (NSControl)accessibleElement).cell() != null) {
                accessibleElement = viewAsControl.cell();
            }
            accessibleElement.accessibilitySetOverrideValue(this.textView.cell(), OS.NSAccessibilityTitleUIElementAttribute);
            NSArray controlArray = NSArray.arrayWithObject(accessibleElement);
            this.textView.cell().accessibilitySetOverrideValue(controlArray, OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if ((this.style & 2) != 0) {
            float lineWidth = ((NSBox)this.view).borderWidth();
            if ((this.style & 0x100) != 0) {
                height = (int)Math.ceil(lineWidth * 2.0f);
            } else {
                width = (int)Math.ceil(lineWidth * 2.0f);
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            int border = this.getBorderWidth();
            return new Point(width += border * 2, height += border * 2);
        }
        if (this.isImage) {
            if (this.image != null) {
                NSImage nsimage = this.image.handle;
                NSSize size = nsimage.size();
                width = (int)size.width;
                height = (int)size.height;
            } else {
                height = 0;
                width = 0;
            }
        } else {
            NSSize size = null;
            if ((this.style & 0x40) != 0 && wHint != -1) {
                NSRect rect = new NSRect();
                rect.width = wHint;
                rect.height = hHint != -1 ? (float)hHint : Float.MAX_VALUE;
                size = this.textView.cell().cellSizeForBounds(rect);
            } else {
                size = this.textView.cell().cellSize();
            }
            width = (int)Math.ceil(size.width);
            height = (int)Math.ceil(size.height);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.state |= 0x800;
        NSBox widget = (NSBox)new SWTBox().alloc();
        widget.init();
        widget.setTitle(NSString.stringWith(""));
        if ((this.style & 2) != 0) {
            widget.setBoxType(2);
            NSView child = (NSView)new SWTView().alloc().init();
            widget.setContentView(child);
            child.release();
        } else {
            widget.setBorderType(0);
            widget.setBorderWidth(0.0f);
            widget.setBoxType(4);
            NSSize offsetSize = new NSSize();
            widget.setContentViewMargins(offsetSize);
            NSImageView imageWidget = (NSImageView)new SWTImageView().alloc();
            imageWidget.init();
            imageWidget.setImageScaling(2);
            NSTextField textWidget = (NSTextField)new SWTTextField().alloc();
            textWidget.init();
            textWidget.setBordered(false);
            textWidget.setEditable(false);
            textWidget.setDrawsBackground(false);
            NSTextFieldCell cell = new NSTextFieldCell(textWidget.cell());
            cell.setWraps((this.style & 0x40) != 0);
            widget.addSubview(imageWidget);
            widget.addSubview(textWidget);
            widget.setContentView(textWidget);
            this.imageView = imageWidget;
            this.textView = textWidget;
            this._setAlignment();
        }
        this.view = widget;
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
    }

    NSAttributedString createString() {
        NSAttributedString attribStr = this.createString(this.text, null, this.foreground, this.style, (this.style & 0x40) != 0, true, true);
        attribStr.autorelease();
        return attribStr;
    }

    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    void deregister() {
        super.deregister();
        if (this.textView != null) {
            this.display.removeWidget(this.textView);
            this.display.removeWidget(this.textView.cell());
        }
        if (this.imageView != null) {
            this.display.removeWidget(this.imageView);
            this.display.removeWidget(this.imageView.cell());
        }
    }

    NSView eventView() {
        return ((NSBox)this.view).contentView();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    boolean isDescribedByLabel() {
        return false;
    }

    void register() {
        super.register();
        if (this.textView != null) {
            this.display.addWidget(this.textView, this);
            this.display.addWidget(this.textView.cell(), this);
        }
        if (this.imageView != null) {
            this.display.addWidget(this.imageView, this);
            this.display.addWidget(this.imageView.cell(), this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.textView != null) {
            this.textView.release();
        }
        if (this.imageView != null) {
            this.imageView.release();
        }
        this.textView = null;
        this.imageView = null;
    }

    void removeRelation() {
        if (this.textView != null) {
            this.textView.cell().accessibilitySetOverrideValue(null, OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this._setAlignment();
    }

    void updateBackground() {
        if ((this.style & 2) != 0) {
            return;
        }
        NSColor nsColor = null;
        nsColor = this.backgroundImage != null ? NSColor.colorWithPatternImage(this.backgroundImage.handle) : (this.background != null ? NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]) : NSColor.clearColor());
        ((NSBox)this.view).setFillColor(nsColor);
    }

    void _setAlignment() {
        if (this.image != null) {
            if ((this.style & 0x20000) != 0) {
                this.imageView.setImageAlignment(8);
            }
            if ((this.style & 0x4000) != 0) {
                this.imageView.setImageAlignment(4);
            }
            if ((this.style & 0x1000000) != 0) {
                this.imageView.setImageAlignment(0);
            }
        }
        if (this.text != null) {
            NSCell cell = new NSCell(this.textView.cell());
            cell.setAttributedStringValue(this.createString());
        }
    }

    void setFont(NSFont font) {
        if (this.textView != null) {
            NSCell cell = new NSCell(this.textView.cell());
            cell.setAttributedStringValue(this.createString());
            this.textView.setFont(font);
        }
    }

    void setForeground(float[] color) {
        if ((this.style & 2) != 0) {
            return;
        }
        NSCell cell = new NSCell(this.textView.cell());
        cell.setAttributedStringValue(this.createString());
    }

    boolean setTabItemFocus() {
        return false;
    }

    public void setImage(Image image) {
        NSImage current;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.isImage = true;
        if (image != null && (current = this.imageView.image()) != null && current.id == image.handle.id) {
            this.imageView.setImage(null);
        }
        this.imageView.setImage(image != null ? image.handle : null);
        ((NSBox)this.view).setContentView(this.imageView);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.isImage = false;
        this.text = string;
        NSCell cell = new NSCell(this.textView.cell());
        cell.setAttributedStringValue(this.createString());
        ((NSBox)this.view).setContentView(this.textView);
    }
}

