/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.groupby.GroupByCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;

public class GroupByCommandHandler
extends AbstractLayerCommandHandler<GroupByCommand> {
    private final GroupByHeaderLayer groupByHeaderLayer;

    public GroupByCommandHandler(GroupByHeaderLayer groupByHeaderLayer) {
        this.groupByHeaderLayer = groupByHeaderLayer;
    }

    protected boolean doCommand(GroupByCommand command) {
        GroupByCommand.GroupByAction action = command.getAction();
        int[] columnIndexes = command.getIndexes();
        boolean fireEvent = false;
        switch (action) {
            case ADD: {
                fireEvent = this.groupByHeaderLayer.getGroupByModel().addAllGroupByColumnIndexes(columnIndexes);
                break;
            }
            case CLEAR: {
                this.groupByHeaderLayer.getGroupByModel().clearGroupByColumnIndexes();
                fireEvent = true;
                break;
            }
            case REMOVE: {
                fireEvent = this.groupByHeaderLayer.getGroupByModel().removeAllGroupByColumnIndexes(columnIndexes);
                break;
            }
            case SET: {
                this.groupByHeaderLayer.getGroupByModel().setGroupByColumnIndexes(columnIndexes);
                fireEvent = true;
            }
        }
        if (fireEvent) {
            this.groupByHeaderLayer.fireLayerEvent((ILayerEvent)new VisualRefreshEvent((ILayer)this.groupByHeaderLayer));
        }
        return true;
    }

    public Class<GroupByCommand> getCommandClass() {
        return GroupByCommand.class;
    }
}

