/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.ComboBoxGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.GlazedListsFilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataLayer;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterRowConfiguration;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterUtils;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboUpdateEvent;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.IFilterRowComboUpdateListener;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearAllFiltersCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearFilterCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ToggleFilterRowCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.grid.command.InitializeGridCommand;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

public class ComboBoxFilterRowHeaderComposite<T>
extends CompositeLayer
implements IFilterRowComboUpdateListener {
    protected final FilterRowDataLayer<T> filterRowDataLayer;
    protected boolean filterRowVisible = true;
    protected final FilterRowComboBoxDataProvider<T> comboBoxDataProvider;
    protected final ComboBoxGlazedListsFilterStrategy<T> filterStrategy;
    private IConfigRegistry configRegistry;

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this(filterList, bodyLayer, baseCollection, bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, true);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterList, new GlazedListsFilterRowComboBoxDataProvider<T>(bodyLayer, baseCollection, bodyDataColumnAccessor), bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, boolean lazyLoading, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterList, new GlazedListsFilterRowComboBoxDataProvider<T>(bodyLayer, baseCollection, bodyDataColumnAccessor, lazyLoading), bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterList, matcherEditor, new GlazedListsFilterRowComboBoxDataProvider<T>(bodyLayer, baseCollection, bodyDataColumnAccessor), bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> bodyDataColumnAccessor, boolean lazyLoading, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterList, matcherEditor, new GlazedListsFilterRowComboBoxDataProvider<T>(bodyLayer, baseCollection, bodyDataColumnAccessor, lazyLoading), bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this(filterList, comboBoxDataProvider, bodyDataColumnAccessor, columnHeaderLayer, columnHeaderDataProvider, configRegistry, true);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(new ComboBoxGlazedListsFilterStrategy<T>(comboBoxDataProvider, filterList, bodyDataColumnAccessor, configRegistry), comboBoxDataProvider, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, IColumnAccessor<T> bodyDataColumnAccessor, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(new ComboBoxGlazedListsFilterStrategy<T>(comboBoxDataProvider, filterList, matcherEditor, bodyDataColumnAccessor, configRegistry), comboBoxDataProvider, columnHeaderLayer, columnHeaderDataProvider, configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(ComboBoxGlazedListsFilterStrategy<T> filterStrategy, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(filterStrategy, comboBoxDataProvider, columnHeaderLayer, new FilterRowDataLayer(filterStrategy, columnHeaderLayer, columnHeaderDataProvider, configRegistry), configRegistry, useDefaultConfiguration);
    }

    public ComboBoxFilterRowHeaderComposite(ComboBoxGlazedListsFilterStrategy<T> filterStrategy, FilterRowComboBoxDataProvider<T> comboBoxDataProvider, ILayer columnHeaderLayer, FilterRowDataLayer<T> filterRowDataLayer, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        super(1, 2);
        this.filterStrategy = filterStrategy;
        this.comboBoxDataProvider = comboBoxDataProvider;
        this.comboBoxDataProvider.addCacheUpdateListener((IFilterRowComboUpdateListener)this);
        this.filterRowDataLayer = filterRowDataLayer;
        this.configRegistry = configRegistry;
        this.setAllValuesSelected();
        this.setChildLayer("columnHeader", columnHeaderLayer, 0, 0);
        this.setChildLayer("FILTER_ROW", (ILayer)this.filterRowDataLayer, 0, 1);
        if (useDefaultConfiguration) {
            this.addConfiguration((IConfiguration)new ComboBoxFilterRowConfiguration(this.comboBoxDataProvider));
        }
    }

    public void saveState(String prefix, Properties properties) {
        FilterRowDataProvider dataProvider = this.filterRowDataLayer.getFilterRowDataProvider();
        int i = 0;
        while (i < dataProvider.getColumnCount()) {
            if (!ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)i) && "SELECT_ALL".equals(dataProvider.getFilterIndexToObjectMap().get(i))) {
                this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap().remove(i);
            }
            ++i;
        }
        super.saveState(prefix, properties);
    }

    public void loadState(String prefix, Properties properties) {
        boolean wasEnabled = this.comboBoxDataProvider.isUpdateEventsEnabled();
        this.comboBoxDataProvider.disableUpdateEvents();
        super.loadState(prefix, properties);
        if (wasEnabled) {
            this.comboBoxDataProvider.enableUpdateEvents();
        }
    }

    public FilterRowDataLayer<T> getFilterRowDataLayer() {
        return this.filterRowDataLayer;
    }

    public CompositeMatcherEditor<T> getMatcherEditor() {
        return this.filterStrategy.getMatcherEditor();
    }

    public ComboBoxGlazedListsFilterStrategy<T> getFilterStrategy() {
        return this.filterStrategy;
    }

    public FilterRowComboBoxDataProvider<T> getComboBoxDataProvider() {
        return this.comboBoxDataProvider;
    }

    public boolean isFilterRowVisible() {
        return this.filterRowVisible;
    }

    public void setFilterRowVisible(boolean filterRowVisible) {
        this.filterRowVisible = filterRowVisible;
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent(this.filterRowDataLayer));
    }

    public void setAllValuesSelected() {
        this.setAllValuesSelected(false);
    }

    public void setAllValuesSelected(boolean performEditorCheck) {
        FilterRowDataProvider dataProvider = this.filterRowDataLayer.getFilterRowDataProvider();
        dataProvider.getFilterIndexToObjectMap().clear();
        int i = 0;
        while (i < dataProvider.getColumnCount()) {
            boolean setAllSelected;
            boolean bl = setAllSelected = performEditorCheck ? ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)i) : true;
            if (setAllSelected) {
                dataProvider.getFilterIndexToObjectMap().put(i, "SELECT_ALL");
            }
            ++i;
        }
        this.getFilterStrategy().applyFilter(dataProvider.getFilterIndexToObjectMap());
    }

    public Object getDataValueByPosition(int compositeColumnPosition, int compositeRowPosition) {
        if (this.filterRowVisible && compositeRowPosition == this.getRowCount() - 1) {
            Object filterValue = super.getDataValueByPosition(compositeColumnPosition, compositeRowPosition);
            int columnIndex = this.getColumnIndexByPosition(compositeColumnPosition);
            if (!ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)columnIndex) && "SELECT_ALL".equals(filterValue)) {
                this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap().remove(columnIndex);
                filterValue = null;
            }
            return filterValue;
        }
        return super.getDataValueByPosition(compositeColumnPosition, compositeRowPosition);
    }

    public int getHeight() {
        if (this.filterRowVisible) {
            return super.getHeight();
        }
        return this.getHeightOffset(1);
    }

    public int getRowCount() {
        if (this.filterRowVisible) {
            return super.getRowCount();
        }
        return super.getRowCount() - 1;
    }

    public boolean doCommand(ILayerCommand command) {
        boolean handled = false;
        if (command instanceof ToggleFilterRowCommand) {
            this.setFilterRowVisible(!this.filterRowVisible);
            return true;
        }
        if (command instanceof ClearFilterCommand && command.convertToTargetLayer((ILayer)this)) {
            int columnPosition = ((ClearFilterCommand)command).getColumnPosition();
            int columnIndex = this.getColumnIndexByPosition(columnPosition);
            if (ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)columnIndex)) {
                this.filterRowDataLayer.setDataValueByPosition(columnPosition, 0, (Object)"SELECT_ALL");
                handled = true;
            }
        } else if (command instanceof ClearAllFiltersCommand) {
            this.setAllValuesSelected(true);
            ILayer childLayer = this.getChildLayerByLayoutCoordinate(0, 0);
            childLayer.fireLayerEvent((ILayerEvent)new FilterAppliedEvent(childLayer, true));
            handled = true;
        } else if (command instanceof InitializeGridCommand) {
            this.setAllValuesSelected(true);
        } else if (command instanceof DisposeResourcesCommand) {
            this.comboBoxDataProvider.dispose();
        }
        if (handled) {
            this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this));
            return true;
        }
        return super.doCommand(command);
    }

    public void handleEvent(FilterRowComboUpdateEvent event) {
        Map filterIndexToObjectMap = this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap();
        int i = 0;
        while (i < event.updateContentSize()) {
            Object filterObject = filterIndexToObjectMap.get(event.getColumnIndex(i));
            if (filterObject instanceof Collection) {
                Collection filterCollection = (Collection)filterObject;
                if (event.getAddedItems(i) != null && !event.getAddedItems(i).isEmpty()) {
                    HashSet itemsToAdd = new HashSet(event.getAddedItems(i));
                    itemsToAdd.removeAll(new HashSet(filterCollection));
                    filterCollection.addAll(itemsToAdd);
                }
                if (event.getRemovedItems(i) != null && !event.getRemovedItems(i).isEmpty()) {
                    filterCollection.removeAll(event.getRemovedItems(i));
                }
            }
            ++i;
        }
        this.getFilterStrategy().applyFilter(this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap());
        if (event.updateContentSize() > 1) {
            this.fireLayerEvent((ILayerEvent)new FilterAppliedEvent((ILayer)this));
        }
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof FilterAppliedEvent) {
            FilterAppliedEvent filterEvent = (FilterAppliedEvent)event;
            int columnIndex = filterEvent.getColumnIndex();
            if (columnIndex >= 0 && ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)columnIndex)) {
                Map filterIndexToObjectMap = this.filterRowDataLayer.getFilterRowDataProvider().getFilterIndexToObjectMap();
                Object filterObject = filterIndexToObjectMap.get(columnIndex);
                filterEvent.setFilterComboEditor(true);
                filterEvent.setCleared(ComboBoxFilterUtils.isAllSelected((int)columnIndex, filterObject, this.comboBoxDataProvider));
            } else if (columnIndex == -1 && filterEvent.isCleared() && this.filterStrategy.hasComboBoxFilterEditorRegistered()) {
                filterEvent.setFilterComboEditor(true);
            }
        }
        super.handleLayerEvent(event);
    }
}

