/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableShortSet
extends AbstractMutableSet<Short>
implements MutableSet<Short> {
    private final MutableShortSet delegate;

    public BoxedMutableShortSet(MutableShortSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public Short getFirst() {
        throw new UnsupportedOperationException();
    }

    public Short getLast() {
        throw new UnsupportedOperationException();
    }

    public void each(Procedure<? super Short> procedure) {
        this.delegate.each(arg_0 -> procedure.value(arg_0));
    }

    @Override
    public boolean add(Short item) {
        return this.delegate.add(item.shortValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Short && this.delegate.contains(((Short)object).shortValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Short && this.delegate.remove(((Short)object).shortValue());
    }

    public void clear() {
        this.delegate.clear();
    }

    public ParallelUnsortedSetIterable<Short> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public Iterator<Short> iterator() {
        return new BoxedPrimitiveShortSetIterator(this.delegate.shortIterator());
    }

    private static final class BoxedPrimitiveShortSetIterator
    implements Iterator<Short> {
        private final MutableShortIterator delegate;

        private BoxedPrimitiveShortSetIterator(MutableShortIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Short next() {
            return this.delegate.next();
        }
    }
}

