/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.workbench.browser.UrlHyperlink;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.CommentLink;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritCommentLinkDetector {
    private static final Pattern PATTERN_HYPERLINK = Pattern.compile("href=\"([^\"]*)\"");
    private List<IHyperlink> links;
    private final TaskRepository repository;
    private final List<CommentLink> commentLinks;

    public GerritCommentLinkDetector(TaskRepository repository, GerritConfigX config) {
        this(repository, config.getCommentLinks2());
    }

    public GerritCommentLinkDetector(TaskRepository repository, List<CommentLink> commentLinks) {
        this.repository = repository;
        this.commentLinks = commentLinks;
    }

    public List<IHyperlink> findHyperlinks(String text, int index, int textOffset) {
        if (this.commentLinks == null) {
            return null;
        }
        this.links = null;
        for (CommentLink commentLink : this.commentLinks) {
            Matcher replaceMatcher = PATTERN_HYPERLINK.matcher(commentLink.getReplace());
            if (!replaceMatcher.find()) continue;
            String href = replaceMatcher.group(1);
            Pattern findPattern = Pattern.compile(commentLink.getFind());
            this.findHyperlinks(findPattern.matcher(text), index, textOffset, href);
        }
        return this.links;
    }

    private void findHyperlinks(Matcher matcher, int index, int textOffset, String href) {
        while (matcher.find()) {
            if (index != -1 && (index < matcher.start() || index > matcher.end())) continue;
            if (this.links == null) {
                this.links = new ArrayList<IHyperlink>();
            }
            Object url = href;
            int i = 1;
            while (i <= matcher.groupCount()) {
                url = ((String)url).replaceAll(Pattern.quote("$" + i), matcher.group(i));
                ++i;
            }
            if (!((String)url).startsWith("http")) {
                if (!this.repository.getUrl().endsWith("/")) {
                    url = "/" + (String)url;
                }
                url = this.repository.getUrl() + (String)url;
            }
            int start = matcher.start();
            Region region = new Region(textOffset + start, matcher.end() - start);
            this.links.add((IHyperlink)new UrlHyperlink((IRegion)region, (String)url));
        }
    }
}

