/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.RefreshCommitSupplier;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public class SearcherTaxonomyManager
extends ReferenceManager<SearcherAndTaxonomy> {
    private final SearcherFactory searcherFactory;
    private final long taxoEpoch;
    private final DirectoryTaxonomyWriter taxoWriter;
    private RefreshCommitSupplier refreshCommitSupplier = new RefreshCommitSupplier(this){};

    public SearcherTaxonomyManager(IndexWriter writer, SearcherFactory searcherFactory, DirectoryTaxonomyWriter taxoWriter) throws IOException {
        this(writer, true, searcherFactory, taxoWriter);
    }

    public SearcherTaxonomyManager(IndexWriter writer, boolean applyAllDeletes, SearcherFactory searcherFactory, DirectoryTaxonomyWriter taxoWriter) throws IOException {
        this(writer, applyAllDeletes, searcherFactory, taxoWriter, null);
    }

    public SearcherTaxonomyManager(IndexWriter writer, boolean applyAllDeletes, SearcherFactory searcherFactory, DirectoryTaxonomyWriter taxoWriter, RefreshCommitSupplier refreshCommitSupplier) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.taxoWriter = taxoWriter;
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoWriter);
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)searcherFactory, (IndexReader)DirectoryReader.open((IndexWriter)writer, (boolean)applyAllDeletes, (boolean)false), null), taxoReader);
        this.taxoEpoch = taxoWriter.getTaxonomyEpoch();
        if (refreshCommitSupplier != null) {
            this.refreshCommitSupplier = refreshCommitSupplier;
        }
    }

    public SearcherTaxonomyManager(Directory indexDir, Directory taxoDir, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoDir);
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)searcherFactory, (IndexReader)DirectoryReader.open((Directory)indexDir), null), taxoReader);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
    }

    public SearcherTaxonomyManager(IndexReader reader, DirectoryTaxonomyReader taxoReader, SearcherFactory searcherFactory) throws IOException {
        this(reader, taxoReader, searcherFactory, null);
    }

    public SearcherTaxonomyManager(IndexReader reader, DirectoryTaxonomyReader taxoReader, SearcherFactory searcherFactory, RefreshCommitSupplier refreshCommitSupplier) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)searcherFactory, (IndexReader)reader, null), taxoReader);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
        if (refreshCommitSupplier != null) {
            this.refreshCommitSupplier = refreshCommitSupplier;
        }
    }

    protected void decRef(SearcherAndTaxonomy ref) throws IOException {
        ref.searcher.getIndexReader().decRef();
        ref.taxonomyReader.decRef();
    }

    protected boolean tryIncRef(SearcherAndTaxonomy ref) throws IOException {
        if (ref.searcher.getIndexReader().tryIncRef()) {
            if (ref.taxonomyReader.tryIncRef()) {
                return true;
            }
            ref.searcher.getIndexReader().decRef();
        }
        return false;
    }

    protected SearcherAndTaxonomy refreshIfNeeded(SearcherAndTaxonomy ref) throws IOException {
        IndexCommit refreshCommit;
        IndexReader r = ref.searcher.getIndexReader();
        DirectoryReader dr = (DirectoryReader)r;
        DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)dr, (IndexCommit)(refreshCommit = this.refreshCommitSupplier.getSearcherRefreshCommit(dr)));
        if (newReader == null) {
            return null;
        }
        DirectoryTaxonomyReader tr = null;
        try {
            tr = TaxonomyReader.openIfChanged(ref.taxonomyReader);
        }
        catch (Throwable t1) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{newReader});
            }
            catch (Throwable t2) {
                t2.addSuppressed(t2);
            }
            throw t1;
        }
        if (tr == null) {
            ref.taxonomyReader.incRef();
            tr = ref.taxonomyReader;
        } else if (this.taxoWriter != null && this.taxoWriter.getTaxonomyEpoch() != this.taxoEpoch) {
            IOUtils.close((Closeable[])new Closeable[]{newReader, tr});
            throw new IllegalStateException("DirectoryTaxonomyWriter.replaceTaxonomy was called, which is not allowed when using SearcherTaxonomyManager");
        }
        return new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)this.searcherFactory, (IndexReader)newReader, (IndexReader)r), tr);
    }

    long getSearcherCommitGeneration() throws IOException {
        SearcherAndTaxonomy sat = (SearcherAndTaxonomy)this.acquire();
        long gen = ((DirectoryReader)sat.searcher.getIndexReader()).getIndexCommit().getGeneration();
        this.release(sat);
        return gen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSearcherCurrent() throws IOException {
        SearcherAndTaxonomy sat = (SearcherAndTaxonomy)this.acquire();
        try {
            IndexReader r = sat.searcher.getIndexReader();
            assert (r instanceof DirectoryReader) : "searcher's IndexReader should be a DirectoryReader, but got " + String.valueOf(r);
            boolean bl = ((DirectoryReader)r).isCurrent();
            return bl;
        }
        finally {
            this.release(sat);
        }
    }

    boolean isTaxonomyCurrent() throws IOException {
        SearcherAndTaxonomy sat = (SearcherAndTaxonomy)this.acquire();
        try {
            boolean bl = sat.taxonomyReader.getInternalIndexReader().isCurrent();
            return bl;
        }
        finally {
            this.release(sat);
        }
    }

    protected int getRefCount(SearcherAndTaxonomy reference) {
        return reference.searcher.getIndexReader().getRefCount();
    }

    public record SearcherAndTaxonomy(IndexSearcher searcher, DirectoryTaxonomyReader taxonomyReader) {
    }
}

