// Copyright 2009 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gwtjsonrpc.client.event;

import com.google.gwtjsonrpc.client.JsonUtil;
import com.google.gwtjsonrpc.client.impl.JsonCall;

/** Event received by {@link RpcCompleteHandler} */
public class RpcCompleteEvent extends BaseRpcEvent<RpcCompleteHandler> {
  private static Type<RpcCompleteHandler> TYPE = null;
  private static RpcCompleteEvent INSTANCE = null;

  /**
   * Fires a RpcCompleteEvent.
   * <p>
   * For internal use only.
   * 
   * @param eventData
   */
  @SuppressWarnings("unchecked")
  public static void fire(Object eventData) {
    assert eventData instanceof JsonCall : "For internal use only";
    if (TYPE != null) { // If we have a TYPE, we have an INSTANCE.
      INSTANCE.call = (JsonCall) eventData;
      JsonUtil.fireEvent(INSTANCE);
    }
  }

  /**
   * Gets the type associated with this event.
   * 
   * @return returns the event type
   */
  public static Type<RpcCompleteHandler> getType() {
    if (TYPE == null) {
      TYPE = new Type<RpcCompleteHandler>();
      INSTANCE = new RpcCompleteEvent();
    }
    return TYPE;
  }

  private RpcCompleteEvent() {
    // Do nothing
  }

  @Override
  public Type<RpcCompleteHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(final RpcCompleteHandler handler) {
    handler.onRpcComplete(this);
  }

  @Override
  protected void kill() {
    super.kill();
    call = null;
  }
}
