/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.net.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;

public abstract class AbstractTestFixture {
    protected final String connectorKind;
    private String description;
    private String repositoryName;
    protected final String repositoryUrl;
    private String simpleInfo;
    protected boolean useCertificateAuthentication;
    private boolean useShortUserNames;
    private final Map<String, String> properties;
    private Map<String, String> defaultproperties;

    public AbstractTestFixture(String connectorKind, String repositoryUrl) {
        this.connectorKind = connectorKind;
        this.repositoryUrl = repositoryUrl;
        this.useCertificateAuthentication = repositoryUrl.contains("/secure/");
        this.properties = null;
    }

    public AbstractTestFixture(String connectorKind, FixtureConfiguration config) {
        this.connectorKind = connectorKind;
        this.repositoryUrl = config.getUrl();
        this.useCertificateAuthentication = this.repositoryUrl.contains("/secure/");
        this.properties = config.getProperties();
    }

    protected abstract AbstractTestFixture getDefault();

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInfo() {
        return this.repositoryName + " " + this.simpleInfo;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getSimpleInfo() {
        return this.simpleInfo;
    }

    public boolean isExcluded() {
        String excludeFixture = System.getProperty("mylyn.test.exclude", "");
        String[] excludeFixtureArray = excludeFixture.split(",");
        return new HashSet<String>(Arrays.asList(excludeFixtureArray)).contains(this.getRepositoryUrl());
    }

    public boolean isUseCertificateAuthentication() {
        return this.useCertificateAuthentication;
    }

    public boolean isUseShortUserNames() {
        return this.useShortUserNames;
    }

    public RepositoryLocation location() throws Exception {
        return this.location(CommonTestUtil.PrivilegeLevel.USER);
    }

    public RepositoryLocation location(CommonTestUtil.PrivilegeLevel level) throws Exception {
        return this.location(level, NetUtil.getProxyForUrl((String)this.repositoryUrl));
    }

    public RepositoryLocation location(CommonTestUtil.PrivilegeLevel level, Proxy proxy) throws Exception {
        if (level == CommonTestUtil.PrivilegeLevel.ANONYMOUS) {
            return this.location(null, null, proxy);
        }
        UserCredentials credentials = CommonTestUtil.getCredentials(level);
        String userName = credentials.getUserName();
        if (this.isUseShortUserNames() && userName.contains("@")) {
            userName = userName.substring(0, userName.indexOf("@"));
        }
        return this.location(userName, credentials.getPassword(), proxy);
    }

    public RepositoryLocation location(String username, String password) throws Exception {
        return this.location(username, password, NetUtil.getProxyForUrl((String)this.repositoryUrl));
    }

    public RepositoryLocation location(String username, String password, Proxy proxy) throws Exception {
        RepositoryLocation location = new RepositoryLocation();
        location.setUrl(this.repositoryUrl);
        location.setProxy(proxy);
        location.setCredentialsStore((ICredentialsStore)new InMemoryCredentialsStore());
        if (username != null && password != null) {
            location.setCredentials(AuthenticationType.REPOSITORY, (AuthenticationCredentials)new UserCredentials(username, password));
        }
        if (this.isUseCertificateAuthentication() && !this.forceDefaultKeystore(proxy)) {
            location.setCredentials(AuthenticationType.CERTIFICATE, (AuthenticationCredentials)CommonTestUtil.getCertificateCredentials());
        }
        return location;
    }

    private boolean forceDefaultKeystore(Proxy proxy) {
        return proxy != null && System.getProperty("javax.net.ssl.keyStore") != null;
    }

    public void setUseCertificateAuthentication(boolean useCertificateAuthentication) {
        this.useCertificateAuthentication = useCertificateAuthentication;
    }

    public void setUseShortUserNames(boolean useShortUsernames) {
        this.useShortUserNames = useShortUsernames;
    }

    protected void setInfo(String repositoryName, String version, String description) {
        Assert.isNotNull((Object)repositoryName);
        Assert.isNotNull((Object)version);
        this.repositoryName = repositoryName;
        this.simpleInfo = version;
        this.description = description;
        if (description != null && description.length() > 0) {
            this.simpleInfo = String.valueOf(this.simpleInfo) + "/" + description;
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getDefaultproperties() {
        return this.defaultproperties;
    }

    public String getProperty(String key) {
        String result = null;
        if (this.getProperties() != null) {
            result = this.getProperties().get(key);
            if (result == null) {
                result = this.getDefaultproperties().get(key);
            }
        } else {
            result = this.getDefaultproperties().get(key);
        }
        return result;
    }

    public void setDefaultproperties(Map<String, String> defaultproperties) {
        this.defaultproperties = defaultproperties;
    }
}

