/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import junit.framework.TestCase;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.tests.ui.MockTextViewer;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskHyperlinkDetector;

public class TaskHyperlinkDetectorTest
extends TestCase {
    protected MockRepositoryConnectorUi connectorUi;
    protected TaskRepository repository;

    protected void setUp() throws Exception {
        this.repository = TaskTestUtil.createMockRepository();
        this.connectorUi = new MockRepositoryConnectorUi();
    }

    protected IHyperlink[] detect(String text, int start, int length) {
        AbstractTaskHyperlinkDetector detector = this.createHyperlinkDetector();
        return detector.detectHyperlinks((ITextViewer)new MockTextViewer(text), (IRegion)new Region(start, length), true);
    }

    protected AbstractTaskHyperlinkDetector createHyperlinkDetector() {
        TaskHyperlinkDetector detector = new TaskHyperlinkDetector(){

            protected TaskRepository getTaskRepository(ITextViewer textViewer) {
                return TaskHyperlinkDetectorTest.this.repository;
            }

            protected AbstractRepositoryConnectorUi getConnectorUi(TaskRepository repository) {
                return TaskHyperlinkDetectorTest.this.connectorUi;
            }
        };
        return detector;
    }

    public void testMultiple() {
        IHyperlink[] links = this.detect("123 456 789", 4, 5);
        TaskHyperlinkDetectorTest.assertNotNull((Object)links);
        TaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
        TaskHyperlinkDetectorTest.assertEquals((Object)new Region(4, 3), (Object)links[0].getHyperlinkRegion());
        TaskHyperlinkDetectorTest.assertEquals((Object)new Region(8, 1), (Object)links[1].getHyperlinkRegion());
    }

    public void testMultipleFullRegion() {
        IHyperlink[] links = this.detect("123 456 789", 0, 11);
        TaskHyperlinkDetectorTest.assertEquals((int)3, (int)links.length);
        TaskHyperlinkDetectorTest.assertEquals((Object)new Region(0, 3), (Object)links[0].getHyperlinkRegion());
        TaskHyperlinkDetectorTest.assertEquals((Object)new Region(4, 3), (Object)links[1].getHyperlinkRegion());
        TaskHyperlinkDetectorTest.assertEquals((Object)new Region(8, 3), (Object)links[2].getHyperlinkRegion());
    }

    public void testSingleZeroLenghtRegion() {
        IHyperlink[] links = this.detect("123 456 789", 5, 0);
        TaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
    }

    public void testSpaceZeroLengthRegion() {
        IHyperlink[] links = this.detect("1234  789", 5, 0);
        TaskHyperlinkDetectorTest.assertNull((Object)links);
    }
}

