/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.validation;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.wikitext.validation.ValidationProblem;

public class ValidationProblemAnnotation
extends Annotation {
    private static final String TYPE_BASE = "org.eclipse.mylyn.wikitext.ui.editor.problem.validation";
    public static final String TYPE_WARNING = "org.eclipse.mylyn.wikitext.ui.editor.problem.validation.warning";
    public static final String TYPE_ERROR = "org.eclipse.mylyn.wikitext.ui.editor.problem.validation.error";

    public ValidationProblemAnnotation(ValidationProblem problem) {
        super(ValidationProblemAnnotation.computeType(problem), false, problem.getMessage());
    }

    private static String computeType(ValidationProblem problem) {
        return switch (problem.getSeverity()) {
            case ValidationProblem.Severity.ERROR -> TYPE_ERROR;
            case ValidationProblem.Severity.WARNING -> TYPE_WARNING;
            default -> throw new IllegalStateException(problem.getSeverity().name());
        };
    }

    public static boolean isValidationAnnotation(Annotation annotation) {
        return annotation.getType().startsWith(TYPE_BASE);
    }
}

