/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.Messages;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class BuildNotification
extends AbstractUiNotification {
    private static final String ID_EVENT_PLAN_STATUS_CHANGED = "org.eclipse.mylyn.builds.ui.events.PlanStatusChanged";
    private static final String ID_EVENT_BUILD_COMPLETED = "org.eclipse.mylyn.builds.ui.events.BuildCompleted";
    private static final String ID_EVENT_BUILD_STARTED = "org.eclipse.mylyn.builds.ui.events.BuildStarted";
    private final IBuildElement element;
    private String description;
    private String label;

    public BuildNotification(String eventId, IBuildElement element) {
        super(eventId);
        this.element = element;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Image getNotificationImage() {
        if (this.element instanceof IBuildPlan) {
            return CommonImages.getImage((ImageDescriptor)BuildLabelProvider.getImageDescriptor(((IBuildPlan)this.element).getStatus()));
        }
        return null;
    }

    public Image getNotificationKindImage() {
        return CommonImages.getImage((ImageDescriptor)BuildImages.VIEW_BUILDS);
    }

    public void open() {
        BuildsUi.open(this.element);
    }

    public static BuildNotification createNotification(Notification msg) {
        if (msg.getOldValue() == msg.getNewValue()) {
            return null;
        }
        BuildNotification notification = null;
        if (msg.getNotifier() instanceof IBuildPlan) {
            IBuildPlan plan = (IBuildPlan)msg.getNotifier();
            int featureId = msg.getFeatureID(IBuildPlan.class);
            if (featureId == 15) {
                notification = new BuildNotification(ID_EVENT_PLAN_STATUS_CHANGED, (IBuildElement)msg.getNotifier());
                notification.setLabel(NLS.bind((String)Messages.BuildNotification_planLabelStatus, (Object)plan.getLabel(), (Object)plan.getStatus().toString()));
                notification.setDescription(plan.getSummary());
            }
        }
        return notification;
    }

    public Date getDate() {
        return null;
    }
}

