/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.ui.client.adapters.ValueBoxEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.AutoDirectionHandler;
import com.google.gwt.i18n.client.BidiPolicy;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.text.shared.Parser;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.impl.TextBoxImpl;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBoxBase<T>
extends FocusWidget
implements HasChangeHandlers,
HasName,
HasDirectionEstimator,
HasValue<T>,
AutoDirectionHandler.Target,
IsEditor<ValueBoxEditor<T>> {
    private static TextBoxImpl impl = (TextBoxImpl)GWT.create(TextBoxImpl.class);
    private final AutoDirectionHandler autoDirHandler = AutoDirectionHandler.addTo((AutoDirectionHandler.Target)this, BidiPolicy.isBidiEnabled());
    private final Parser<T> parser;
    private final Renderer<T> renderer;
    private Event currentEvent;
    private boolean valueChangeHandlerInitialized;

    protected ValueBoxBase(Element elem, Renderer<T> renderer, Parser<T> parser) {
        super(elem);
        this.renderer = renderer;
        this.parser = parser;
    }

    @Override
    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler(handler, ChangeEvent.getType());
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.valueChangeHandlerInitialized = true;
            this.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ValueChangeEvent.fire(ValueBoxBase.this, ValueBoxBase.this.getValue());
                }
            });
        }
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public ValueBoxEditor<T> asEditor() {
        return ValueBoxEditor.of(this);
    }

    public void cancelKey() {
        if (this.currentEvent != null) {
            DOM.eventPreventDefault(this.currentEvent);
        }
    }

    public int getCursorPos() {
        return impl.getCursorPos(this.getElement());
    }

    @Override
    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.autoDirHandler.getDirectionEstimator();
    }

    @Override
    public String getName() {
        return DOM.getElementProperty(this.getElement(), "name");
    }

    public String getSelectedText() {
        int start = this.getCursorPos();
        if (start < 0) {
            return "";
        }
        int length = this.getSelectionLength();
        return this.getText().substring(start, start + length);
    }

    public int getSelectionLength() {
        return impl.getSelectionLength(this.getElement());
    }

    @Override
    public String getText() {
        return DOM.getElementProperty(this.getElement(), "value");
    }

    @Override
    public T getValue() {
        try {
            return this.getValueOrThrow();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public T getValueOrThrow() throws ParseException {
        String text = this.getText();
        T parseResult = this.parser.parse(text);
        if ("".equals(text)) {
            return null;
        }
        return parseResult;
    }

    public boolean isReadOnly() {
        return DOM.getElementPropertyBoolean(this.getElement(), "readOnly");
    }

    @Override
    public void onBrowserEvent(Event event) {
        int type = DOM.eventGetType(event);
        if ((type & 0x380) != 0) {
            this.currentEvent = event;
            super.onBrowserEvent(event);
            this.currentEvent = null;
        } else {
            super.onBrowserEvent(event);
        }
    }

    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this, listener);
    }

    public void selectAll() {
        int length = this.getText().length();
        if (length > 0) {
            this.setSelectionRange(0, length);
        }
    }

    public void setAlignment(TextAlignment align) {
        DOM.setStyleAttribute(this.getElement(), "textAlign", align.getTextAlignString());
    }

    public void setCursorPos(int pos) {
        this.setSelectionRange(pos, 0);
    }

    @Override
    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.getElement(), direction);
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.autoDirHandler.setDirectionEstimator(enabled);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.autoDirHandler.setDirectionEstimator(directionEstimator);
    }

    @Deprecated
    public void setKey(char key) {
        if (this.currentEvent != null) {
            DOM.eventSetKeyCode(this.currentEvent, key);
        }
    }

    @Override
    public void setName(String name) {
        DOM.setElementProperty(this.getElement(), "name", name);
    }

    public void setReadOnly(boolean readOnly) {
        DOM.setElementPropertyBoolean(this.getElement(), "readOnly", readOnly);
        String readOnlyStyle = "readonly";
        if (readOnly) {
            this.addStyleDependentName(readOnlyStyle);
        } else {
            this.removeStyleDependentName(readOnlyStyle);
        }
    }

    public void setSelectionRange(int pos, int length) {
        if (!this.isAttached()) {
            return;
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length must be a positive integer. Length: " + length);
        }
        if (pos < 0 || length + pos > this.getText().length()) {
            throw new IndexOutOfBoundsException("From Index: " + pos + "  To Index: " + (pos + length) + "  Text Length: " + this.getText().length());
        }
        impl.setSelectionRange(this.getElement(), pos, length);
    }

    @Override
    public void setText(String text) {
        DOM.setElementProperty(this.getElement(), "value", text != null ? text : "");
        this.autoDirHandler.refreshDirection();
    }

    @Override
    public void setValue(T value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(T value, boolean fireEvents) {
        T oldValue = this.getValue();
        this.setText(this.renderer.render(value));
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual(this, oldValue, value);
        }
    }

    protected TextBoxImpl getImpl() {
        return impl;
    }

    @Override
    protected void onLoad() {
        super.onLoad();
        this.autoDirHandler.refreshDirection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAlignment {
        CENTER{

            String getTextAlignString() {
                return "center";
            }
        }
        ,
        JUSTIFY{

            String getTextAlignString() {
                return "justify";
            }
        }
        ,
        LEFT{

            String getTextAlignString() {
                return "left";
            }
        }
        ,
        RIGHT{

            String getTextAlignString() {
                return "right";
            }
        };


        abstract String getTextAlignString();
    }
}

