/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.parameterized;

import com.google.common.base.Function;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import org.eclipse.xtext.junit4.parameterized.ActualCollection;
import org.eclipse.xtext.junit4.parameterized.ExpectationCollection;
import org.eclipse.xtext.junit4.parameterized.IParameterProvider;
import org.eclipse.xtext.junit4.parameterized.TestExpectationValidator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Pair;
import org.junit.Assert;
import org.junit.ComparisonFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@TestExpectationValidator(validator=CSVResultValidator.class)
public @interface XpectCommaSeparatedValues {
    public boolean caseSensitive() default true;

    public Class<? extends Function<Object, String>> itemFormatter() default ActualCollection.ToString.class;

    public int maxItemsPerLine() default -1;

    public int maxLineWidth() default 80;

    public boolean ordered() default false;

    public boolean quoted() default false;

    public boolean whitespaceSensitive() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CSVResultValidator
    implements TestExpectationValidator.ITestExpectationValidator<Iterable<Object>> {
        protected XpectCommaSeparatedValues cfg;

        public CSVResultValidator(XpectCommaSeparatedValues cfg) {
            this.cfg = cfg;
        }

        protected String str(int length) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < length) {
                b.append(" ");
                ++i;
            }
            return b.toString();
        }

        @Override
        public void validate(XtextResource res, IParameterProvider.IExpectation expectation, @TestExpectationValidator.TestResult Iterable<Object> actual) {
            Assert.assertNotNull((Object)res);
            Assert.assertNotNull((Object)expectation);
            Assert.assertNotNull((Object)expectation.getExpectation());
            Assert.assertNotNull(actual);
            ExpectationCollection exp = new ExpectationCollection();
            exp.setCaseSensitive(this.cfg.caseSensitive());
            exp.setOrdered(this.cfg.ordered());
            exp.setQuoted(this.cfg.quoted());
            exp.setSeparator(',');
            exp.setWhitespaceSensitive(this.cfg.whitespaceSensitive());
            exp.init(expectation.getExpectation());
            ActualCollection act = new ActualCollection();
            act.setCaseSensitive(this.cfg.caseSensitive());
            act.setOrdered(this.cfg.ordered());
            act.setQuoted(this.cfg.quoted());
            act.setSeparator(',');
            act.setWhitespaceSensitive(this.cfg.whitespaceSensitive());
            act.init(actual, this.cfg.itemFormatter());
            if (!exp.matches(act)) {
                StringBuilder expString = new StringBuilder();
                StringBuilder actString = new StringBuilder();
                boolean expWrap = false;
                boolean expEmpty = false;
                boolean actWrap = false;
                int lineLength = 0;
                int lineCount = 0;
                for (Pair<Collection<ExpectationCollection.ExpectationItem>, ActualCollection.ActualItem> pair : exp.map(act)) {
                    String expItem = null;
                    String actItem = null;
                    if (pair.getFirst() != null && !((Collection)pair.getFirst()).isEmpty()) {
                        expItem = pair.getSecond() != null ? ((ActualCollection.ActualItem)pair.getSecond()).getEscaped() : ((ExpectationCollection.ExpectationItem)((Collection)pair.getFirst()).iterator().next()).getEscaped();
                    } else if (pair.getSecond() != null) {
                        expItem = this.str(((ActualCollection.ActualItem)pair.getSecond()).getEscaped().length());
                    }
                    if (pair.getSecond() != null) {
                        boolean width;
                        actItem = ((ActualCollection.ActualItem)pair.getSecond()).getEscaped();
                        boolean count = this.cfg.maxItemsPerLine() > 0 && ++lineCount > this.cfg.maxItemsPerLine();
                        boolean bl = width = this.cfg.maxLineWidth() > 0 && (lineLength += actItem.length() + 2) > this.cfg.maxLineWidth();
                        if (count || width) {
                            actWrap = true;
                            expWrap = true;
                        }
                    }
                    if (expItem != null && expString.length() > 0) {
                        if (expWrap) {
                            expString.append(expEmpty ? "\n" : ",\n");
                            expWrap = false;
                        } else {
                            expString.append(expEmpty ? "  " : ", ");
                        }
                    }
                    if (actItem != null && actString.length() > 0) {
                        if (actWrap) {
                            actString.append(",\n");
                            actWrap = false;
                            lineCount = 0;
                            lineLength = 0;
                        } else {
                            actString.append(", ");
                        }
                    }
                    if (expItem != null) {
                        expString.append(expItem);
                        boolean bl = expEmpty = expItem.trim().length() == 0;
                    }
                    if (actItem == null) continue;
                    actString.append(actItem);
                }
                String expDoc = IParameterProvider.IExpectation.Util.replace(res, expectation, expString.toString());
                String actDoc = IParameterProvider.IExpectation.Util.replace(res, expectation, actString.toString());
                throw new ComparisonFailure("", expDoc, actDoc);
            }
        }
    }
}

