/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIStrings {
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private FeatureCallToJavaMapping featureCallToJavaMapping;

    public String parameters(JvmIdentifiableElement element) {
        if (element instanceof JvmExecutable) {
            return "(" + this.parameterTypes((Iterable<JvmFormalParameter>)((JvmExecutable)element).getParameters()) + ")";
        }
        return "";
    }

    public String arguments(XAbstractFeatureCall featureCall) {
        List<XExpression> arguments = this.featureCallToJavaMapping.getActualArguments(featureCall);
        return "(" + this.expressionTypes(arguments) + ")";
    }

    public String arguments(XConstructorCall constructorCall) {
        return "(" + this.expressionTypes((Iterable<XExpression>)constructorCall.getArguments()) + ")";
    }

    public String typeParameters(Iterable<? extends JvmTypeParameter> typeParams) {
        if (!Iterables.isEmpty(typeParams)) {
            return "<" + this.toString(typeParams) + ">";
        }
        return "";
    }

    public String typeParameters(JvmIdentifiableElement element) {
        if (element instanceof JvmTypeParameterDeclarator) {
            return "<" + this.toString((Iterable<? extends JvmIdentifiableElement>)((JvmTypeParameterDeclarator)element).getTypeParameters()) + ">";
        }
        return "";
    }

    public String typeArguments(XAbstractFeatureCall featureCall) {
        return "<" + this.referencesToString((Iterable<? extends JvmTypeReference>)featureCall.getTypeArguments()) + ">";
    }

    public String typeArguments(XConstructorCall constructorCall) {
        return "<" + this.referencesToString((Iterable<? extends JvmTypeReference>)constructorCall.getTypeArguments()) + ">";
    }

    protected String toString(Iterable<? extends JvmIdentifiableElement> elements) {
        StringBuilder buffer = new StringBuilder();
        boolean needsSeparator = false;
        for (JvmIdentifiableElement jvmIdentifiableElement : elements) {
            if (needsSeparator) {
                buffer.append(", ");
            }
            needsSeparator = true;
            if (jvmIdentifiableElement != null) {
                buffer.append(jvmIdentifiableElement.getSimpleName());
                continue;
            }
            buffer.append("[null]");
        }
        return buffer.toString();
    }

    protected String referencesToString(Iterable<? extends JvmTypeReference> elements) {
        StringBuilder buffer = new StringBuilder();
        boolean needsSeparator = false;
        for (JvmTypeReference jvmTypeReference : elements) {
            if (needsSeparator) {
                buffer.append(", ");
            }
            needsSeparator = true;
            if (jvmTypeReference != null) {
                if (jvmTypeReference instanceof JvmAnyTypeReference) {
                    buffer.append("Object");
                    continue;
                }
                buffer.append(jvmTypeReference.getSimpleName());
                continue;
            }
            buffer.append("[null]");
        }
        return buffer.toString();
    }

    protected String expressionTypes(Iterable<XExpression> expressions) {
        return this.referencesToString(Iterables.transform(expressions, (Function)new Function<XExpression, JvmTypeReference>(){

            public JvmTypeReference apply(XExpression from) {
                return UIStrings.this.typeProvider.getType(from);
            }
        }));
    }

    protected String parameterTypes(Iterable<JvmFormalParameter> parameters) {
        return this.referencesToString(Iterables.transform(parameters, (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

            public JvmTypeReference apply(JvmFormalParameter from) {
                return from.getParameterType();
            }
        }));
    }
}

