/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.compiler.FeatureCallCompiler;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.typing.Closures;

public class XbaseCompiler
extends FeatureCallCompiler {
    @Inject
    private Closures closures;
    @Inject
    private TypeArgumentContextProvider ctxProvider;

    protected void _toJavaStatement(XBlockExpression expr, IAppendable b, boolean isReferenced) {
        if (expr.getExpressions().isEmpty()) {
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToJavaStatement((XExpression)expr.getExpressions().get(0), b, isReferenced);
            return;
        }
        if (isReferenced) {
            this.declareLocalVariable(expr, b);
        }
        b.append("\n{").increaseIndentation();
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b, false);
            } else {
                this.internalToJavaStatement(ex, b, isReferenced);
                if (isReferenced) {
                    b.append("\n").append(this.getVarName(expr, b)).append(" = (");
                    this.internalToConvertedExpression(ex, b, null);
                    b.append(");");
                }
            }
            ++i;
        }
        b.decreaseIndentation().append("\n}");
    }

    protected void _toJavaExpression(XBlockExpression expr, IAppendable b) {
        if (expr.getExpressions().isEmpty()) {
            b.append("null");
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToConvertedExpression((XExpression)expr.getExpressions().get(0), b, null);
            return;
        }
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XTryCatchFinallyExpression expr, IAppendable b, boolean isReferenced) {
        if (isReferenced && !this.isPrimitiveVoid(expr)) {
            this.declareLocalVariable(expr, b);
        }
        b.append("\ntry {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getExpression());
        this.internalToJavaStatement(expr.getExpression(), b, canBeReferenced);
        if (canBeReferenced) {
            b.append("\n").append(this.getVarName(expr, b)).append(" = ");
            this.internalToConvertedExpression(expr.getExpression(), b, null);
            b.append(";");
        }
        b.decreaseIndentation().append("\n}");
        this.appendCatchAndFinally(expr, b, isReferenced);
    }

    protected void appendCatchAndFinally(XTryCatchFinallyExpression expr, IAppendable b, boolean isReferenced) {
        for (XCatchClause catchClause : expr.getCatchClauses()) {
            JvmTypeReference type = catchClause.getDeclaredParam().getParameterType();
            String name = this.declareNameInVariableScope((EObject)catchClause.getDeclaredParam(), b);
            b.append(" catch (final ");
            this.serialize(type, expr, b);
            b.append(" ").append(name).append(") {");
            b.increaseIndentation();
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(catchClause.getExpression());
            this.internalToJavaStatement(catchClause.getExpression(), b, canBeReferenced);
            if (canBeReferenced) {
                b.append("\n").append(this.getVarName(expr, b)).append(" = ");
                this.internalToConvertedExpression(catchClause.getExpression(), b, null);
                b.append(";");
            }
            b.decreaseIndentation();
            b.append("\n}");
        }
        XExpression finallyExp = expr.getFinallyExpression();
        if (finallyExp != null) {
            b.append(" finally {").increaseIndentation();
            this.internalToJavaStatement(finallyExp, b, false);
            b.decreaseIndentation().append("\n}");
        }
    }

    protected void _toJavaExpression(XTryCatchFinallyExpression expr, IAppendable b) {
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XThrowExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
        b.append("\nthrow ");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(";");
    }

    protected void _toJavaExpression(XThrowExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaExpression(XInstanceOfExpression expr, IAppendable b) {
        b.append("(");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(" instanceof ").append(expr.getType()).append(")");
    }

    protected void _toJavaStatement(XInstanceOfExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
    }

    protected void _toJavaExpression(XVariableDeclaration expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XVariableDeclaration varDeclaration, IAppendable b, boolean isReferenced) {
        if (varDeclaration.getRight() != null) {
            this.internalToJavaStatement(varDeclaration.getRight(), b, true);
        }
        b.append("\n");
        if (!varDeclaration.isWriteable()) {
            b.append("final ");
        }
        JvmTypeReference type = null;
        type = varDeclaration.getType() != null ? varDeclaration.getType() : this.getTypeProvider().getType(varDeclaration.getRight());
        this.serialize(type, varDeclaration, b);
        b.append(" ");
        b.append(this.declareNameInVariableScope(varDeclaration, b));
        b.append(" = ");
        if (varDeclaration.getRight() != null) {
            this.internalToConvertedExpression(varDeclaration.getRight(), b, type);
        } else if (this.getPrimitives().isPrimitive(type)) {
            Primitives.Primitive primitiveKind = this.getPrimitives().primitiveKind((JvmPrimitiveType)type.getType());
            switch (primitiveKind) {
                case Boolean: {
                    b.append("false");
                    break;
                }
                default: {
                    b.append("0");
                    break;
                }
            }
        } else {
            b.append("null");
        }
        b.append(";");
    }

    protected void _toJavaExpression(XWhileExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XWhileExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.append("\nBoolean ").append(this.declareNameInVariableScope(expr, b)).append(" = ");
        this.internalToJavaExpression(expr.getPredicate(), b);
        b.append(";");
        b.append("\nwhile (");
        b.append(this.getVarName(expr, b));
        b.append(") {").increaseIndentation();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.append("\n").append(this.getVarName(expr, b)).append(" = ");
        this.internalToJavaExpression(expr.getPredicate(), b);
        b.append(";");
        b.decreaseIndentation().append("\n}");
    }

    protected void _toJavaExpression(XDoWhileExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XDoWhileExpression expr, IAppendable b, boolean isReferenced) {
        b.append("\nBoolean ").append(this.declareNameInVariableScope(expr, b)).append(";");
        b.append("\ndo {").increaseIndentation();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.append("\n").append(this.getVarName(expr, b)).append(" = ");
        this.internalToJavaExpression(expr.getPredicate(), b);
        b.append(";");
        b.decreaseIndentation().append("\n} while(");
        b.append(this.getVarName(expr, b));
        b.append(");");
    }

    protected void _toJavaExpression(XForLoopExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XForLoopExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getForExpression(), b, true);
        b.append("\nfor (final ");
        JvmTypeReference paramType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)expr.getDeclaredParam());
        this.serialize(paramType, expr, b);
        b.append(" ");
        String varName = this.declareNameInVariableScope((EObject)expr.getDeclaredParam(), b);
        b.append(varName);
        b.append(" : ");
        this.internalToJavaExpression(expr.getForExpression(), b);
        b.append(") {").increaseIndentation();
        this.internalToJavaStatement(expr.getEachExpression(), b, false);
        b.decreaseIndentation().append("\n}");
    }

    protected void _toJavaStatement(final XConstructorCall expr, final IAppendable b, boolean isReferenced) {
        for (XExpression arg : expr.getArguments()) {
            this.internalToJavaStatement(arg, b, true);
        }
        Later later = new Later(){

            public void exec() {
                b.append("new ");
                JvmTypeReference producedType = XbaseCompiler.this.getTypeProvider().getType(expr);
                XbaseCompiler.this.serialize(producedType, expr, b, false, false, true, false);
                b.append("(");
                XbaseCompiler.this.appendArguments((List<? extends XExpression>)expr.getArguments(), (JvmExecutable)expr.getConstructor(), expr, b);
                b.append(")");
            }
        };
        if (isReferenced) {
            this.declareLocalVariable((XExpression)expr, b, later);
        } else {
            b.append("\n");
            later.exec();
            b.append(";");
        }
    }

    protected void _toJavaExpression(XConstructorCall expr, IAppendable b) {
        String varName = this.getVarName(expr, b);
        b.append(varName);
    }

    protected void _toJavaStatement(XReturnExpression expr, IAppendable b, boolean isReferenced) {
        if (expr.getExpression() != null) {
            this.internalToJavaStatement(expr.getExpression(), b, true);
            b.append("\nreturn ");
            this.internalToJavaExpression(expr.getExpression(), b);
            b.append(";");
        } else {
            b.append("\nreturn;");
        }
    }

    protected void _toJavaExpression(XReturnExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaExpression(XCastedExpression expr, IAppendable b) {
        b.append("((");
        this.serialize(expr.getType(), expr, b);
        b.append(") ");
        this.internalToConvertedExpression(expr.getTarget(), b, expr.getType());
        b.append(")");
    }

    protected void _toJavaStatement(XCastedExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getTarget(), b, isReferenced);
    }

    protected void _toJavaStatement(XIfExpression expr, IAppendable b, boolean isReferenced) {
        if (isReferenced) {
            this.declareLocalVariable(expr, b);
        }
        this.internalToJavaStatement(expr.getIf(), b, true);
        b.append("\nif (");
        this.internalToJavaExpression(expr.getIf(), b);
        b.append(") {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getThen());
        this.internalToJavaStatement(expr.getThen(), b, canBeReferenced);
        if (canBeReferenced) {
            b.append("\n");
            b.append(this.getVarName(expr, b));
            b.append(" = ");
            this.internalToConvertedExpression(expr.getThen(), b, null);
            b.append(";");
        }
        b.decreaseIndentation().append("\n}");
        if (expr.getElse() != null) {
            b.append(" else {").increaseIndentation();
            boolean canElseBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getElse());
            this.internalToJavaStatement(expr.getElse(), b, canElseBeReferenced);
            if (canElseBeReferenced) {
                b.append("\n");
                b.append(this.getVarName(expr, b));
                b.append(" = ");
                this.internalToConvertedExpression(expr.getElse(), b, null);
                b.append(";");
            }
            b.decreaseIndentation().append("\n}");
        }
    }

    protected void _toJavaExpression(XIfExpression expr, IAppendable b) {
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XSwitchExpression expr, IAppendable b, boolean isReferenced) {
        JvmTypeReference type = this.getTypeProvider().getType(expr);
        String switchResultName = b.declareVariable(Tuples.pair((Object)expr, (Object)"result"), "_switchResult");
        if (isReferenced) {
            b.append("\n");
            this.serialize(type, expr, b);
            b.append(" ").append(switchResultName).append(" = ");
            b.append(this.getDefaultValueLiteral(expr));
            b.append(";");
        }
        this.internalToJavaStatement(expr.getSwitch(), b, true);
        String name = this.getNameProvider().getSimpleName(expr);
        name = name != null ? this.makeJavaIdentifier(name) : "__valOfSwitchOver";
        JvmTypeReference typeReference = this.getTypeProvider().getType(expr.getSwitch());
        b.append("\nfinal ");
        this.serialize(typeReference, expr, b);
        b.append(" ");
        String variableName = b.declareVariable(expr, name);
        b.append(variableName);
        b.append(" = ");
        this.internalToJavaExpression(expr.getSwitch(), b);
        b.append(";");
        b.append("\nboolean ");
        String matchedVariable = b.declareVariable(Tuples.pair((Object)expr, (Object)"matches"), "matched");
        b.append(matchedVariable).append(" = false;");
        for (XCasePart casePart : expr.getCases()) {
            b.append("\nif (!").append(matchedVariable).append(") {");
            b.increaseIndentation();
            if (casePart.getTypeGuard() != null) {
                b.append("\nif (");
                b.append(variableName);
                b.append(" instanceof ");
                b.append(casePart.getTypeGuard().getType());
                b.append(") {");
                b.increaseIndentation();
                String simpleName = this.getNameProvider().getSimpleName(casePart);
                if (simpleName != null) {
                    b.append("\nfinal ");
                    this.serialize(casePart.getTypeGuard(), (EObject)casePart, b);
                    b.append(" ");
                    String typeGuardName = b.declareVariable(casePart, simpleName);
                    b.append(typeGuardName);
                    b.append(" = (");
                    this.serialize(casePart.getTypeGuard(), (EObject)casePart, b);
                    b.append(") ").append(variableName).append(";");
                }
            }
            if (casePart.getCase() != null) {
                this.internalToJavaStatement(casePart.getCase(), b, true);
                b.append("\nif (");
                JvmTypeReference convertedType = this.getTypeProvider().getType(casePart.getCase());
                if (this.getTypeReferences().is(convertedType, Boolean.TYPE) || this.getTypeReferences().is(convertedType, Boolean.class)) {
                    this.internalToJavaExpression(casePart.getCase(), b);
                } else {
                    JvmTypeReference typeRef = this.getTypeReferences().getTypeForName(ObjectExtensions.class, (EObject)expr, new JvmTypeReference[0]);
                    this.serialize(typeRef, (EObject)casePart, b);
                    b.append(".operator_equals(").append(variableName).append(",");
                    this.internalToJavaExpression(casePart.getCase(), b);
                    b.append(")");
                }
                b.append(") {");
                b.increaseIndentation();
            }
            b.append("\n").append(matchedVariable).append("=true;");
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(casePart.getThen());
            this.internalToJavaStatement(casePart.getThen(), b, canBeReferenced);
            if (canBeReferenced) {
                b.append("\n").append(switchResultName).append(" = ");
                this.internalToConvertedExpression(casePart.getThen(), b, null);
                b.append(";");
            }
            if (casePart.getCase() != null) {
                b.decreaseIndentation().append("\n}");
            }
            if (casePart.getTypeGuard() != null) {
                b.decreaseIndentation().append("\n}");
            }
            b.decreaseIndentation();
            b.append("\n}");
        }
        if (expr.getDefault() != null) {
            b.append("\nif (!").append(matchedVariable).append(") {");
            b.increaseIndentation();
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getDefault());
            this.internalToJavaStatement(expr.getDefault(), b, canBeReferenced);
            if (canBeReferenced) {
                b.append("\n").append(switchResultName).append(" = ");
                this.internalToConvertedExpression(expr.getDefault(), b, null);
                b.append(";");
            }
            b.decreaseIndentation();
            b.append("\n}");
        }
    }

    protected void _toJavaExpression(XSwitchExpression expr, IAppendable b) {
        b.append(this.getVarName(Tuples.pair((Object)expr, (Object)"result"), b));
    }

    protected void _toJavaStatement(XClosure closure, IAppendable b, boolean isReferenced) {
        if (!isReferenced) {
            throw new IllegalArgumentException("a closure definition does not cause any side-effects");
        }
        JvmTypeReference type = this.getTypeProvider().getType(closure);
        ITypeArgumentContext context = this.ctxProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest(type));
        b.append("\n").append("final ");
        this.serialize(type, closure, b);
        b.append(" ");
        String variableName = b.declareVariable(closure, "_function");
        b.append(variableName).append(" = ");
        b.append("new ");
        this.serialize(type, closure, b, false, false, true, false);
        b.append("() {");
        b.increaseIndentation().increaseIndentation();
        try {
            Object superElement;
            b.openScope();
            JvmOperation operation = this.closures.findImplementingOperation(type, closure.eResource());
            JvmTypeReference returnType = context.resolve(operation.getReturnType());
            b.append("\npublic ");
            this.serialize(returnType, closure, b, false, false, true, true);
            b.append(" ").append(operation.getSimpleName());
            b.append("(");
            EList<JvmFormalParameter> closureParams = closure.getFormalParameters();
            Iterator iter = closureParams.iterator();
            while (iter.hasNext()) {
                JvmFormalParameter param = (JvmFormalParameter)iter.next();
                JvmTypeReference parameterType2 = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)param);
                JvmTypeReference parameterType = context.resolve(parameterType2);
                b.append("final ");
                this.serialize(parameterType, closure, b, false, false, true, true);
                b.append(" ");
                String name = this.declareNameInVariableScope((EObject)param, b);
                b.append(name);
                if (!iter.hasNext()) continue;
                b.append(" , ");
            }
            b.append(") {");
            b.increaseIndentation();
            Object element = b.getObject("this");
            if (element instanceof JvmType) {
                b.declareVariable(element, String.valueOf(((JvmType)element).getSimpleName()) + ".this");
            }
            if ((superElement = b.getObject("super")) instanceof JvmType) {
                b.declareVariable(superElement, String.valueOf(((JvmType)superElement).getSimpleName()) + ".super");
            }
            this.compile(closure.getExpression(), b, operation.getReturnType());
        }
        finally {
            b.closeScope();
        }
        b.decreaseIndentation();
        b.append("\n}");
        b.decreaseIndentation().append("\n};").decreaseIndentation();
    }

    protected void _toJavaExpression(XClosure call, IAppendable b) {
        b.append(this.getVarName(call, b));
    }
}

