/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.actions.IOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeContentProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeLabelProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineRefreshJob;
import org.eclipse.xtext.ui.util.DisplayRunHelper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlinePage
extends ContentOutlinePage
implements ISourceViewerAware {
    private static final Logger LOG = Logger.getLogger(OutlinePage.class);
    @Inject
    private OutlineNodeLabelProvider labelProvider;
    @Inject
    private OutlineNodeContentProvider contentProvider;
    @Inject
    private IOutlineTreeProvider treeProvider;
    @Inject
    private IOutlineContribution.Composite contribution;
    private IXtextModelListener modelListener;
    private ITextInputListener textInputListener;
    private IXtextDocument xtextDocument;
    private ISourceViewer sourceViewer;
    @Inject
    private OutlineRefreshJob refreshJob;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.configureTree();
        this.configureModelListener();
        this.configureActions();
        this.refreshJob.setOutlinePage(this);
    }

    protected void configureTree() {
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        treeViewer.setUseHashlookup(true);
        List initiallyExpandedNodes = (List)this.xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<List<IOutlineNode>, XtextResource>(){

            public List<IOutlineNode> exec(XtextResource resource) throws Exception {
                return OutlinePage.this.getInitiallyExpandedNodes();
            }
        });
        this.refreshViewer((IOutlineNode)initiallyExpandedNodes.get(0), initiallyExpandedNodes, Collections.<IOutlineNode>emptySet());
    }

    protected List<IOutlineNode> getInitiallyExpandedNodes() {
        IOutlineNode rootNode = this.treeProvider.createRoot(this.xtextDocument);
        ArrayList result = Lists.newArrayList((Object[])new IOutlineNode[]{rootNode});
        this.addChildren(Collections.singletonList(rootNode), result, this.getDefaultExpansionLevel());
        return result;
    }

    protected int getDefaultExpansionLevel() {
        return 1;
    }

    protected void addChildren(List<IOutlineNode> nodes, List<IOutlineNode> allChildren, int depth) {
        for (IOutlineNode node : nodes) {
            List<IOutlineNode> children = node.getChildren();
            if (depth <= 1) continue;
            allChildren.addAll(children);
            this.addChildren(children, allChildren, depth - 1);
        }
    }

    protected void configureModelListener() {
        this.modelListener = new IXtextModelListener(){

            public void modelChanged(XtextResource resource) {
                try {
                    OutlinePage.this.scheduleRefresh();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error refreshing outline", t);
                }
            }
        };
        this.xtextDocument.addModelListener(this.modelListener);
    }

    protected void configureActions() {
        this.contribution.register(this);
    }

    public void dispose() {
        this.contribution.deregister(this);
        this.sourceViewer.removeTextInputListener(this.textInputListener);
        this.xtextDocument.removeModelListener(this.modelListener);
        this.contentProvider.dispose();
        super.dispose();
    }

    @Override
    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
        IDocument document = sourceViewer.getDocument();
        this.xtextDocument = XtextDocumentUtil.get(document);
        Assert.isNotNull((Object)this.xtextDocument);
        this.configureTextInputListener();
    }

    protected void configureTextInputListener() {
        this.textInputListener = new ITextInputListener(){

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                try {
                    if (OutlinePage.this.xtextDocument != null) {
                        OutlinePage.this.xtextDocument.removeModelListener(OutlinePage.this.modelListener);
                    }
                    OutlinePage.this.xtextDocument = XtextDocumentUtil.get(newInput);
                    if (OutlinePage.this.xtextDocument != null) {
                        OutlinePage.this.xtextDocument.addModelListener(OutlinePage.this.modelListener);
                        OutlinePage.this.scheduleRefresh();
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error refreshing outline", t);
                }
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }
        };
        this.sourceViewer.addTextInputListener(this.textInputListener);
    }

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public IXtextDocument getXtextDocument() {
        return this.xtextDocument;
    }

    protected OutlineRefreshJob getRefreshJob() {
        return this.refreshJob;
    }

    public void scheduleRefresh() {
        this.refreshJob.cancel();
        this.refreshJob.schedule();
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public IOutlineTreeProvider getTreeProvider() {
        return this.treeProvider;
    }

    protected void refreshViewer(final IOutlineNode rootNode, final Collection<IOutlineNode> nodesToBeExpanded, final Collection<IOutlineNode> selectedNodes) {
        DisplayRunHelper.runAsyncInDisplayThread(new Runnable(){

            public void run() {
                try {
                    TreeViewer treeViewer = OutlinePage.this.getTreeViewer();
                    if (!treeViewer.getTree().isDisposed()) {
                        treeViewer.setInput((Object)rootNode);
                        treeViewer.expandToLevel(1);
                        treeViewer.setExpandedElements(Iterables.toArray((Iterable)nodesToBeExpanded, IOutlineNode.class));
                        treeViewer.setSelection((ISelection)new StructuredSelection(Iterables.toArray((Iterable)selectedNodes, IOutlineNode.class)));
                        OutlinePage.this.treeUpdated();
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error refreshing outline", t);
                }
            }
        });
    }

    protected void treeUpdated() {
    }
}

