/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.IContextInformationAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContextInformationProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextInformationComputer
implements IUnitOfWork<IContextInformation[], XtextResource>,
IContextInformationAcceptor {
    private final int offset;
    private final ITextViewer viewer;
    private final State state;
    private final Collection<IContextInformation> information = new LinkedHashSet<IContextInformation>();

    public ContextInformationComputer(State state, ITextViewer viewer, int offset) {
        this.state = state;
        this.offset = offset;
        this.viewer = viewer;
    }

    public IContextInformation[] exec(XtextResource resource) throws Exception {
        ContentAssistContext[] contexts;
        IContextInformationAcceptor acceptor = this.state.decorateAcceptor(this);
        ContentAssistContext[] contentAssistContextArray = contexts = this.state.getContextFactory().create(this.viewer, this.offset, resource);
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            ContentAssistContext context = contentAssistContextArray[n2];
            if (acceptor.canAcceptMoreInformation()) {
                this.state.getContextInformationProvider().getContextInformation(context, acceptor);
            }
            ++n2;
        }
        if (this.information.isEmpty()) {
            return null;
        }
        return this.information.toArray(new IContextInformation[this.information.size()]);
    }

    @Override
    public void accept(IContextInformation information) {
        this.information.add(information);
    }

    @Override
    public boolean canAcceptMoreInformation() {
        return true;
    }

    public static interface State {
        public ContentAssistContext.Factory getContextFactory();

        public IContextInformationProvider getContextInformationProvider();

        public IContextInformationAcceptor decorateAcceptor(IContextInformationAcceptor var1);
    }
}

