/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.actions;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

public abstract class AbstractToggleActionContributor {
    private static final Logger logger = Logger.getLogger(AbstractToggleActionContributor.class);
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    private IPropertyChangeListener propertyChangeListener;
    private Action action;
    private IPreferenceStore preferenceStore;

    public abstract String getPreferenceKey();

    protected abstract void stateChanged(boolean var1);

    protected boolean isPropertySet() {
        return this.preferenceStoreAccess.getPreferenceStore().getBoolean(this.getPreferenceKey());
    }

    protected IPreferenceStoreAccess getPreferenceStoreAccess() {
        return this.preferenceStoreAccess;
    }

    protected void toggle() {
        boolean newState = !this.isPropertySet();
        IPreferenceStore store = this.preferenceStoreAccess.getWritablePreferenceStore();
        store.setValue(this.getPreferenceKey(), newState);
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.stateChanged(newState);
    }

    protected abstract void configureAction(Action var1);

    protected Action getAction() {
        if (this.action == null) {
            this.action = new InternalToggleAction(this);
            this.configureAction(this.action);
        }
        return this.action;
    }

    public void initialize(IPreferenceStoreAccess preferenceStoreAccess) {
        preferenceStoreAccess.getWritablePreferenceStore().setDefault(this.getPreferenceKey(), false);
    }

    protected void addPropertyChangeListener() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (AbstractToggleActionContributor.this.getPreferenceKey().equals(event.getProperty()) && event.getOldValue() != event.getNewValue()) {
                    boolean newValue = Boolean.parseBoolean(event.getNewValue().toString());
                    AbstractToggleActionContributor.this.stateChanged(newValue);
                    AbstractToggleActionContributor.this.getAction().setChecked(newValue);
                }
            }
        };
        this.preferenceStore = this.preferenceStoreAccess.getPreferenceStore();
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void removePropertyChangeListener() {
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected static class InternalToggleAction
    extends Action {
        private final AbstractToggleActionContributor contribution;

        protected InternalToggleAction(AbstractToggleActionContributor contribution) {
            this.contribution = contribution;
            this.setId(contribution.getPreferenceKey());
            this.setChecked(contribution.isPropertySet());
        }

        public void run() {
            boolean newState = !this.contribution.isPropertySet();
            this.setChecked(newState);
            this.contribution.toggle();
        }
    }
}

