/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.file;

import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Provider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.ui.file.EclipseProjectConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceConfigProvider
implements Provider<WorkspaceConfig> {
    @Inject
    @Accessors
    private IWorkspaceRoot workspaceRoot;
    @Inject
    @Accessors
    private EclipseOutputConfigurationProvider configurationProvider;

    public WorkspaceConfig get() {
        IPath _location = this.workspaceRoot.getLocation();
        String wsRoot = _location.toString();
        final WorkspaceConfig result = new WorkspaceConfig(wsRoot);
        IProject[] _projects = this.workspaceRoot.getProjects();
        Procedures.Procedure1<IProject> _function = new Procedures.Procedure1<IProject>(){

            public void apply(IProject it) {
                Map _projects = result.getProjects();
                String _name = it.getName();
                EclipseProjectConfig _eclipseProjectConfig = new EclipseProjectConfig(it, EclipseWorkspaceConfigProvider.this.configurationProvider);
                _projects.put(_name, _eclipseProjectConfig);
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)_projects)), (Procedures.Procedure1)_function);
        return result;
    }

    @Pure
    public IWorkspaceRoot getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public void setWorkspaceRoot(IWorkspaceRoot workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    @Pure
    public EclipseOutputConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(EclipseOutputConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }
}

