/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ConstructorLinkingCandidate
extends AbstractPendingLinkingCandidate<XConstructorCall>
implements IConstructorLinkingCandidate {
    public ConstructorLinkingCandidate(XConstructorCall constructorCall, IIdentifiableElementDescription description, ExpressionTypeComputationState state) {
        super(constructorCall, description, state);
    }

    @Override
    public JvmConstructor getConstructor() {
        return (JvmConstructor)this.getFeature();
    }

    @Override
    public XConstructorCall getConstructorCall() {
        return (XConstructorCall)this.getExpression();
    }

    @Override
    protected List<XExpression> getArguments() {
        return this.getConstructorCall().getArguments();
    }

    @Override
    protected IConstructorLinkingCandidate getThis() {
        return this;
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        JvmDeclaredType declaringType = this.getConstructor().getDeclaringType();
        if (declaringType.isAbstract()) {
            String message = "Cannot instantiate the abstract type " + declaringType.getSimpleName();
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.abstract_class_instantiation", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return super.validate(result);
    }

    @Override
    protected boolean isBoundTypeArgumentSkipped(JvmTypeParameter type, ITypeReferenceOwner owner) {
        return super.isBoundTypeArgumentSkipped(type, owner) && this.getConstructor().getDeclaringType() != type.getDeclarator();
    }

    @Override
    protected EReference getDefaultValidationFeature() {
        return XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
    }

    @Override
    @Nullable
    protected EReference getInvalidArgumentsValidationFeature() {
        return null;
    }

    @Override
    protected String getFeatureTypeName() {
        return "constructor";
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        return Lists.transform(this.getConstructorCall().getTypeArguments(), (Function)this.getState().getResolvedTypes().getConverter());
    }

    @Override
    public void applyToModel() {
        this.resolveLinkingProxy(XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, 0);
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        return new FeatureLinkHelper().getDeclaredTypeParameters(this.getConstructor());
    }
}

