/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;

@NonNullByDefault
public abstract class AbstractTypeExpectation
implements ITypeExpectation {
    private final AbstractTypeComputationState state;

    protected AbstractTypeExpectation(AbstractTypeComputationState state) {
        this.state = state;
    }

    public OwnedConverter getConverter() {
        return this.state.getConverter();
    }

    public ITypeReferenceOwner getReferenceOwner() {
        return this.state.getReferenceOwner();
    }

    public boolean isVoidTypeAllowed() {
        LightweightTypeReference expectedType = this.getExpectedType();
        return expectedType != null && expectedType.isType(Void.TYPE);
    }

    public boolean isOwnedBy(ITypeReferenceOwner referenceOwner) {
        LightweightTypeReference expectedType = this.getExpectedType();
        return expectedType == null || expectedType.isOwnedBy(referenceOwner);
    }

    protected AbstractTypeComputationState getState() {
        return this.state;
    }

    protected ResolvedTypes getResolvedTypes() {
        return this.state.getResolvedTypes();
    }

    public UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter typeParameter) {
        return this.getResolvedTypes().createUnboundTypeReference(expression, typeParameter);
    }

    public String toString() {
        LightweightTypeReference expectedType = this.getExpectedType();
        String expectedTypeString = "";
        expectedTypeString = expectedType != null ? expectedType.toString() : (this.isNoTypeExpectation() ? "<no expectation>" : (this.isVoidTypeAllowed() ? "<void allowed>" : "<void not allowed>"));
        return String.valueOf(this.getClass().getSimpleName()) + " [expectation=" + expectedTypeString + "]";
    }
}

