/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.imports.TypeUsages;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedTypes;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xtype.XFunctionTypeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUsageCollector {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private ImplicitlyImportedTypes implicitImports;
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeUsages typeUsages;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    private JvmDeclaredType currentThisType;
    private JvmMember currentContext;
    private XtextResource resource;
    private List<JvmType> implicitStaticImports;
    private List<JvmType> implicitExtensionImports;
    private Set<JvmType> knownTypesForStaticImports;
    private IEObjectDocumentationProviderExtension documentationProvider;

    @Inject
    private void setDocumentationProvider(IEObjectDocumentationProvider documentationProvider) {
        if (documentationProvider instanceof IEObjectDocumentationProviderExtension) {
            this.documentationProvider = (IEObjectDocumentationProviderExtension)documentationProvider;
        }
    }

    public TypeUsages collectTypeUsages(XtextResource resource) {
        if (resource != null && !resource.getContents().isEmpty()) {
            this.resource = resource;
            this.implicitStaticImports = this.implicitImports.getStaticImportClasses((Resource)resource);
            this.implicitExtensionImports = this.implicitImports.getExtensionClasses((Resource)resource);
            this.collectAllReferences((EObject)resource.getContents().get(0));
        }
        return this.typeUsages;
    }

    protected void collectAllReferences(EObject rootElement) {
        TreeIterator contents = EcoreUtil.getAllContents((EObject)rootElement, (boolean)true);
        while (contents.hasNext()) {
            EObject firstJvmElement;
            EObject next = (EObject)contents.next();
            if (next instanceof JvmTypeReference) {
                this.acceptType((JvmTypeReference)next);
                continue;
            }
            if (next instanceof XAnnotation) {
                this.acceptPreferredType(next, XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE);
                continue;
            }
            if (next instanceof XInstanceOfExpression) {
                this.acceptType(((XInstanceOfExpression)next).getType());
                continue;
            }
            if (next instanceof XConstructorCall) {
                this.acceptPreferredType(next, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
                continue;
            }
            if (next instanceof XTypeLiteral) {
                this.acceptPreferredType(next, XbasePackage.Literals.XTYPE_LITERAL__TYPE);
                continue;
            }
            if (next instanceof XFeatureCall) {
                XFeatureCall featureCall = (XFeatureCall)next;
                if (featureCall.getDeclaringType() == null) {
                    this.collectStaticImportsFrom(featureCall);
                    continue;
                }
                this.acceptPreferredType(featureCall, XbasePackage.Literals.XFEATURE_CALL__DECLARING_TYPE);
                continue;
            }
            if (next instanceof XMemberFeatureCall || next instanceof XBinaryOperation || next instanceof XUnaryOperation || next instanceof XAssignment && !Iterables.contains((Iterable)this.currentThisType.getAllFeatures(), (Object)((XAssignment)next).getFeature())) {
                this.collectStaticImportsFrom((XAbstractFeatureCall)next);
                continue;
            }
            Set<EObject> elements = this.associations.getJvmElements(next);
            if (!elements.isEmpty() && (firstJvmElement = elements.iterator().next()) instanceof JvmMember) {
                JvmDeclaredType declaringType;
                JvmDeclaredType jvmDeclaredType = declaringType = firstJvmElement instanceof JvmDeclaredType ? (JvmDeclaredType)firstJvmElement : ((JvmMember)firstJvmElement).getDeclaringType();
                if (this.currentThisType != declaringType) {
                    this.currentThisType = declaringType;
                    this.knownTypesForStaticImports = null;
                }
                this.currentContext = (JvmMember)firstJvmElement;
            }
            this.addJavaDocReferences(next);
        }
    }

    private void collectStaticImportsFrom(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if ((feature instanceof JvmOperation || feature instanceof JvmField) && featureCall.isStatic()) {
            if (featureCall.isExtension()) {
                this.acceptStaticExtensionImport((JvmMember)feature);
            } else {
                this.acceptStaticImport((JvmMember)feature);
            }
        }
    }

    protected void addJavaDocReferences(EObject element) {
        if (element != null && this.documentationProvider != null && this.currentThisType != null) {
            for (INode documentationNode : this.documentationProvider.getDocumentationNodes(element)) {
                for (ReplaceRegion docTypeReference : this.javaDocTypeReferenceProvider.computeTypeRefRegions(documentationNode)) {
                    JvmTypeReference typeRef = this.typeReferences.getTypeForName(docTypeReference.getText(), (Notifier)this.currentThisType, new JvmTypeReference[0]);
                    TextRegion textRegion = new TextRegion(docTypeReference.getOffset(), docTypeReference.getLength());
                    if (typeRef == null || !(typeRef.getType() instanceof JvmDeclaredType)) {
                        this.typeUsages.addUnresolved(docTypeReference.getText(), (ITextRegion)textRegion, (JvmMember)this.currentThisType);
                        continue;
                    }
                    this.typeUsages.addTypeUsage((JvmDeclaredType)typeRef.getType(), docTypeReference.getText(), (ITextRegion)textRegion, (JvmMember)this.currentThisType);
                }
            }
        }
    }

    protected void acceptType(JvmTypeReference ref) {
        if (ref instanceof XFunctionTypeRef || ref instanceof JvmWildcardTypeReference || ref.eContainer() instanceof XFunctionTypeRef && ref.eContainmentFeature() == TypesPackage.Literals.JVM_SPECIALIZED_TYPE_REFERENCE__EQUIVALENT || NodeModelUtils.findActualNodeFor((EObject)ref) == null) {
            return;
        }
        this.acceptPreferredType(ref);
    }

    protected void acceptPreferredType(JvmTypeReference ref) {
        if (ref instanceof JvmParameterizedTypeReference) {
            this.acceptPreferredType((EObject)ref, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        } else {
            this.acceptType(ref.getType(), ref.getIdentifier(), this.locationInFileProvider.getSignificantTextRegion((EObject)ref));
        }
    }

    protected Pair<? extends JvmType, String> findPreferredType(EObject owner, EReference reference) {
        List nodes;
        JvmIdentifiableElement potentiallyLinkedType;
        JvmIdentifiableElement referencedThing = (JvmIdentifiableElement)owner.eGet((EStructuralFeature)reference);
        if (referencedThing != null && owner instanceof XConstructorCall && referencedThing.eIsProxy() && (potentiallyLinkedType = this.batchTypeResolver.resolveTypes(owner).getLinkedFeature((XConstructorCall)owner)) != null && !potentiallyLinkedType.eIsProxy()) {
            referencedThing = potentiallyLinkedType;
        }
        JvmDeclaredType referencedType = null;
        if (referencedThing instanceof JvmDeclaredType) {
            referencedType = (JvmDeclaredType)referencedThing;
        } else if (referencedThing instanceof JvmMember) {
            referencedType = ((JvmMember)referencedThing).getDeclaringType();
        } else if (referencedThing instanceof JvmType) {
            return Tuples.create((Object)((JvmType)referencedThing), null);
        }
        if (referencedType != null && (nodes = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)reference)).size() == 1) {
            String text = NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
            int dollar = text.lastIndexOf(36);
            String preferredTypeText = text;
            if (dollar >= 0) {
                JvmDeclaredType declaredType = referencedType;
                while (declaredType.getDeclaringType() != null && dollar >= 0) {
                    declaredType = declaredType.getDeclaringType();
                    preferredTypeText = text.substring(0, dollar);
                    dollar = text.lastIndexOf(36, dollar - 1);
                }
                return Tuples.create((Object)declaredType, (Object)preferredTypeText);
            }
        }
        return Tuples.create((Object)referencedType, null);
    }

    protected void acceptPreferredType(EObject owner, EReference referenceToTypeOrMember) {
        ITextRegion refRegion = this.locationInFileProvider.getSignificantTextRegion(owner, (EStructuralFeature)referenceToTypeOrMember, 0);
        IParseResult parseResult = this.resource.getParseResult();
        if (parseResult != null) {
            String refText = parseResult.getRootNode().getText().substring(refRegion.getOffset(), refRegion.getOffset() + refRegion.getLength());
            Pair<? extends JvmType, String> preferredType = this.findPreferredType(owner, referenceToTypeOrMember);
            if (preferredType.getFirst() != null && preferredType.getSecond() != null) {
                refRegion = new TextRegion(refRegion.getOffset(), refRegion.getLength() - refText.length() + ((String)preferredType.getSecond()).length());
                refText = (String)preferredType.getSecond();
            }
            this.acceptType((JvmType)preferredType.getFirst(), refText, refRegion);
        }
    }

    protected void acceptType(JvmType type, String refText, ITextRegion refRegion) {
        if (this.currentContext != null) {
            if (type == null || type.eIsProxy()) {
                this.typeUsages.addUnresolved(refText, refRegion, this.currentContext);
            } else if (type instanceof JvmDeclaredType) {
                this.typeUsages.addTypeUsage((JvmDeclaredType)type, refText, refRegion, this.currentContext);
            }
        }
    }

    protected void acceptStaticImport(JvmMember member) {
        JvmDeclaredType declarator = member.getDeclaringType();
        if (!this.needsStaticImport(declarator) || this.implicitStaticImports.contains(declarator)) {
            return;
        }
        this.typeUsages.addStaticImport(declarator);
    }

    protected void acceptStaticExtensionImport(JvmMember member) {
        JvmDeclaredType declarator = member.getDeclaringType();
        if (!this.needsStaticImport(declarator) || this.implicitExtensionImports.contains(declarator)) {
            return;
        }
        this.typeUsages.addExtensionImport(declarator);
    }

    protected boolean needsStaticImport(JvmDeclaredType declarator) {
        if (this.currentThisType == declarator) {
            return false;
        }
        if (this.knownTypesForStaticImports == null && this.currentThisType != null) {
            JvmParameterizedTypeReference reference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            reference.setType((JvmType)this.currentThisType);
            this.knownTypesForStaticImports = this.superTypeCollector.collectSuperTypesAsRawTypes((JvmTypeReference)reference);
        }
        return this.knownTypesForStaticImports == null || !this.knownTypesForStaticImports.contains(declarator);
    }
}

