/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.serializer.impl.FeatureFinderUtil;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.SemanticNodeIterator;
import org.eclipse.xtext.util.Triple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeModelSemanticSequencer
extends AbstractSemanticSequencer {
    @Inject
    protected IValueConverterService valueConverter;

    @Override
    public void createSequence(EObject context, EObject semanticObject) {
        SemanticNodeIterator ni = new SemanticNodeIterator(semanticObject);
        while (ni.hasNext()) {
            Triple<INode, AbstractElement, EObject> node = ni.next();
            if (node.getSecond() instanceof RuleCall) {
                RuleCall rc = (RuleCall)node.getSecond();
                if (rc.getRule().getType().getClassifier() instanceof EClass) {
                    this.acceptSemantic(semanticObject, rc, node.getThird(), (INode)node.getFirst());
                    continue;
                }
                if (GrammarUtil.containingCrossReference((EObject)node.getSecond()) != null) {
                    EStructuralFeature feature = FeatureFinderUtil.getFeature((AbstractElement)node.getSecond(), semanticObject.eClass());
                    this.acceptSemantic(semanticObject, rc, semanticObject.eGet(feature), (INode)node.getFirst());
                    continue;
                }
                String strVal = NodeModelUtils.getTokenText((INode)node.getFirst());
                Object val = this.valueConverter.toValue(strVal, rc.getRule().getName(), (INode)node.getFirst());
                this.acceptSemantic(semanticObject, rc, val, (INode)node.getFirst());
                continue;
            }
            if (node.getSecond() instanceof Keyword) {
                this.acceptSemantic(semanticObject, (AbstractElement)node.getSecond(), ((INode)node.getFirst()).getText(), (INode)node.getFirst());
                continue;
            }
            if (!(node.getSecond() instanceof Action)) continue;
            this.acceptSemantic(semanticObject, (AbstractElement)node.getSecond(), semanticObject, (INode)node.getFirst());
        }
    }

    protected boolean acceptSemantic(EObject semanticObject, AbstractElement ele, Object value, INode node) {
        EStructuralFeature feat;
        Assignment ass = GrammarUtil.containingAssignment(ele);
        int index = -2;
        if (ass != null && (feat = semanticObject.eClass().getEStructuralFeature(ass.getFeature())) != null) {
            index = feat.isMany() ? ((List)semanticObject.eGet(feat)).indexOf(value) : -1;
        }
        String token = node.getText().trim();
        if (ele instanceof Action) {
            if (((Action)ele).getFeature() != null) {
                if (this.sequenceAcceptor.enterAssignedAction((Action)ele, (EObject)value, (ICompositeNode)node)) {
                    this.createSequence(ele, (EObject)value);
                    this.sequenceAcceptor.leaveAssignedAction((Action)ele, (EObject)value);
                }
                return true;
            }
        } else if (GrammarUtil.containingCrossReference(ele) != null) {
            if (ele instanceof RuleCall) {
                RuleCall rc = (RuleCall)ele;
                if (rc.getRule() instanceof ParserRule) {
                    this.sequenceAcceptor.acceptAssignedCrossRefDatatype(rc, token, (EObject)value, index, (ICompositeNode)node);
                    return true;
                }
                if (rc.getRule() instanceof TerminalRule) {
                    this.sequenceAcceptor.acceptAssignedCrossRefTerminal(rc, token, (EObject)value, index, (ILeafNode)node);
                    return true;
                }
                if (rc.getRule() instanceof EnumRule) {
                    this.sequenceAcceptor.acceptAssignedCrossRefEnum(rc, token, (EObject)value, index, (ICompositeNode)node);
                    return true;
                }
            }
        } else if (ass != null) {
            if (ele instanceof RuleCall) {
                RuleCall rc = (RuleCall)ele;
                if (rc.getRule() instanceof ParserRule) {
                    if (rc.getRule().getType().getClassifier() instanceof EClass) {
                        if (this.sequenceAcceptor.enterAssignedParserRuleCall(rc, (EObject)value, (ICompositeNode)node)) {
                            this.createSequence(rc.getRule(), (EObject)value);
                            this.sequenceAcceptor.leaveAssignedParserRuleCall(rc, (EObject)value);
                        } else {
                            this.sequenceAcceptor.acceptAssignedDatatype(rc, token, value, index, (ICompositeNode)node);
                        }
                    }
                    return true;
                }
                if (rc.getRule() instanceof TerminalRule) {
                    this.sequenceAcceptor.acceptAssignedTerminal(rc, token, value, index, (ILeafNode)node);
                    return true;
                }
                if (rc.getRule() instanceof EnumRule) {
                    this.sequenceAcceptor.acceptAssignedEnum(rc, token, value, index, (ICompositeNode)node);
                    return true;
                }
            } else if (ele instanceof Keyword) {
                if (GrammarUtil.isBooleanAssignment(ass)) {
                    this.sequenceAcceptor.acceptAssignedKeyword((Keyword)ele, token, true, index, (ILeafNode)node);
                } else {
                    this.sequenceAcceptor.acceptAssignedKeyword((Keyword)ele, token, (String)value, index, (ILeafNode)node);
                }
                return true;
            }
        }
        return false;
    }

    private INode findContextNode(EObject semanticObject) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(semanticObject);
        for (INode next : node.getAsTreeIterable()) {
            if (next.getGrammarElement() instanceof RuleCall) {
                return next;
            }
            if (!(next.getGrammarElement() instanceof ParserRule) || !(((ParserRule)next.getGrammarElement()).getType().getClassifier() instanceof EClass)) continue;
            return next;
        }
        throw new RuntimeException("no context found");
    }

    public Iterable<EObject> findContexts(EObject semanticObject, boolean consultContainer, Iterable<EObject> contextCandidates) {
        EObject ctx = this.findContextNode(semanticObject).getGrammarElement();
        if (ctx instanceof RuleCall) {
            return Collections.singletonList(((RuleCall)ctx).getRule());
        }
        return Collections.singletonList(ctx);
    }
}

