/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.textmate;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.EOF;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;

public class TerminalRuleToTextMateRule
extends XtextSwitch<String> {
    private final StringBuilder match = new StringBuilder();
    private boolean negationMode = false;

    public String getMatchRegEx(TerminalRule rule) {
        this.doSwitch((EObject)rule.getAlternatives());
        String result = this.match.toString();
        this.match.setLength(0);
        return result;
    }

    public String getMatchRegEx(AbstractElement element) {
        this.doSwitch((EObject)element);
        String result = this.match.toString();
        this.match.setLength(0);
        return result;
    }

    public String caseAlternatives(Alternatives object) {
        if (this.negationMode) {
            for (AbstractElement elem : object.getElements()) {
                this.doSwitch((EObject)elem);
            }
        } else {
            this.match.append("(");
            boolean first = true;
            for (AbstractElement elem : object.getElements()) {
                if (!first) {
                    this.match.append("|");
                }
                first = false;
                this.doSwitch((EObject)elem);
            }
            this.match.append(')');
            this.match.append(Strings.emptyIfNull((String)object.getCardinality()));
        }
        return "";
    }

    public String caseWildcard(Wildcard object) {
        this.match.append(".");
        this.match.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseTerminalRule(TerminalRule object) {
        this.doSwitch((EObject)object.getAlternatives());
        return "";
    }

    public String caseCharacterRange(CharacterRange object) {
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.match.append('(');
        }
        this.match.append("[");
        this.doSwitch((EObject)object.getLeft());
        this.match.append("-");
        this.doSwitch((EObject)object.getRight());
        this.match.append("]");
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.match.append(')');
            this.match.append(Strings.emptyIfNull((String)object.getCardinality()));
        }
        return "";
    }

    public String caseRuleCall(RuleCall object) {
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.match.append("(");
        }
        this.doSwitch((EObject)object.getRule());
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.match.append(")");
            this.match.append(Strings.emptyIfNull((String)object.getCardinality()));
        }
        return "";
    }

    public String caseGroup(Group object) {
        if (this.negationMode) {
            throw new UnsupportedOperationException("Negation is not supported for group rules");
        }
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.match.append("(");
        }
        for (AbstractElement elem : object.getElements()) {
            this.doSwitch((EObject)elem);
        }
        if (!Strings.isEmpty((String)object.getCardinality())) {
            this.match.append(")");
        }
        this.match.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseNegatedToken(NegatedToken object) {
        this.match.append("[^");
        this.negationMode = true;
        this.doSwitch((EObject)object.getTerminal());
        this.negationMode = false;
        this.match.append("]").append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseUntilToken(UntilToken object) {
        throw new UnsupportedOperationException("Until token not supported, use begin and end TextMate rules");
    }

    public String defaultCase(EObject object) {
        throw new UnsupportedOperationException("Encountered a non terminal rule or a terminal rule that is not supported: " + object.toString());
    }

    public String caseKeyword(Keyword object) {
        String value = object.getValue();
        this.match.append(this.toTextMateString(value));
        this.match.append(Strings.emptyIfNull((String)object.getCardinality()));
        return "";
    }

    public String caseEOF(EOF object) {
        return "";
    }

    private String toTextMateString(String base) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < base.length()) {
            char c = base.charAt(i);
            if (c == '*' || c == '+' || c == '.' || c == '?' || c == '\\' || c == '\r' || c == '\n' || c == '\"' || c == '\t' || c == '$' || c == '^' || c == '|' || c == '{' || c == '}' || c == '[' || c == ']') {
                builder.append("\\");
            }
            if (c == ' ') {
                builder.append("\\s");
            } else {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }
}

