/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.AbstractXbaseCompiler;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class TypeConvertingCompiler
extends AbstractXbaseCompiler {
    @Override
    protected final void internalToJavaExpression(XExpression obj, ITreeAppendable appendable) {
        LightweightTypeReference expectedType = this.getLightweightExpectedType(obj);
        this.internalToConvertedExpression(obj, appendable, expectedType);
    }

    @Override
    protected void internalToConvertedExpression(final XExpression obj, ITreeAppendable appendable, LightweightTypeReference toBeConvertedTo) {
        if (toBeConvertedTo != null) {
            actualType = this.getLightweightType(obj);
            if (actualType.isPrimitiveVoid()) {
                actualType = toBeConvertedTo;
            }
            if (this.isToBeCastedAnyType(actualType, obj, appendable) && !toBeConvertedTo.getJavaIdentifier().equals(actualType.getJavaIdentifier())) {
                this.doCastConversion(toBeConvertedTo, appendable, new Later(){

                    @Override
                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
            if (!toBeConvertedTo.getUniqueIdentifier().equals(actualType.getUniqueIdentifier())) {
                this.doConversion(toBeConvertedTo, actualType, appendable, obj, new Later(){

                    @Override
                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
            if (this.mustInsertTypeCast(obj, actualType)) {
                this.doCastConversion(actualType, appendable, new Later(){

                    @Override
                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
        } else {
            actualType = this.getLightweightType(obj);
            if (obj instanceof XAbstractFeatureCall && this.mustInsertTypeCast(obj, actualType)) {
                this.doCastConversion(actualType, appendable, new Later(){

                    @Override
                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
        }
        ITreeAppendable trace = appendable.trace(obj, true);
        this.internalToConvertedExpression(obj, trace);
    }

    private boolean isToBeCastedAnyType(LightweightTypeReference actualType, XExpression obj, ITreeAppendable appendable) {
        if (actualType instanceof AnyTypeReference) {
            if (this.getReferenceName(obj, appendable) != null) {
                return true;
            }
            if (obj instanceof XBlockExpression) {
                XBlockExpression blockExpression = (XBlockExpression)obj;
                EList<XExpression> expressions = blockExpression.getExpressions();
                if (expressions.isEmpty()) {
                    return false;
                }
                if (expressions.size() > 1) {
                    return true;
                }
                XExpression last = (XExpression)expressions.get(0);
                return this.isToBeCastedAnyType(actualType, last, appendable);
            }
        }
        return false;
    }

    private boolean mustInsertTypeCast(XExpression expression, LightweightTypeReference actualType) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes(expression);
        if (this.mustCheckForMandatoryTypeCast(resolvedTypes, expression)) {
            XCastedExpression castedExpression;
            LightweightTypeReference castedExpressionType;
            if (expression instanceof XAbstractFeatureCall) {
                LightweightTypeReference featureType = resolvedTypes.getActualType(((XAbstractFeatureCall)expression).getFeature());
                if (featureType != null && !featureType.isMultiType() && actualType.isAssignableFrom(featureType)) {
                    return false;
                }
                if (featureType != null && featureType.isMultiType()) {
                    JvmTypeReference compliantTypeReference = featureType.toJavaCompliantTypeReference();
                    if (actualType.isAssignableFrom(featureType.getOwner().toLightweightTypeReference(compliantTypeReference))) {
                        return false;
                    }
                }
            }
            if (expression.eContainer() instanceof XCastedExpression && (castedExpressionType = this.getResolvedTypes(castedExpression = (XCastedExpression)expression.eContainer()).getActualType(castedExpression)) != null) {
                return actualType.getType() != castedExpressionType.getType();
            }
            return true;
        }
        return false;
    }

    private boolean mustCheckForMandatoryTypeCast(IResolvedTypes resolvedTypes, XExpression expression) {
        if (resolvedTypes.isRefinedType(expression)) {
            return true;
        }
        LightweightTypeReference actualType = resolvedTypes.getActualType(expression);
        return actualType != null && actualType.isMultiType();
    }

    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        super.internalToJavaExpression(obj, appendable);
    }

    protected void doConversion(LightweightTypeReference left, LightweightTypeReference right, ITreeAppendable appendable, XExpression context, Later expression) {
        if (left.isPrimitive() && !right.isPrimitive()) {
            if (right.isAny()) {
                this.convertWrapperToPrimitive(left, left, context, appendable, expression);
            } else {
                this.convertWrapperToPrimitive(right, right.getPrimitiveIfWrapperType(), context, appendable, expression);
            }
        } else if (right.isPrimitive() && !left.isPrimitive()) {
            this.convertPrimitiveToWrapper(right, right.getWrapperTypeIfPrimitive(), appendable, expression);
        } else if (right.isMultiType()) {
            this.convertMultiType(left, (CompoundTypeReference)right, context, appendable, expression);
        } else if (right.isArray() && !left.isArray() && left.isSubtypeOf(Iterable.class)) {
            this.convertArrayToList(left, appendable, context, expression);
        } else if (this.isJavaConformant(left, right)) {
            if (this.mustInsertTypeCast(context, left)) {
                this.doCastConversion(left, appendable, expression);
            } else {
                expression.exec(appendable);
            }
        } else if (left.isArray() && !right.isArray() && right.isSubtypeOf(Iterable.class)) {
            this.convertListToArray(left, appendable, expression);
        } else if ((this.isFunction(left) && this.isFunction(right) || this.isProcedure(left) && this.isProcedure(right)) && left.getType() == right.getType()) {
            this.doCastConversion(left, appendable, expression);
        } else if (this.isFunction(right) || this.isFunction(left) && this.findImplementingOperation(right) != null) {
            this.convertFunctionType(left, right, appendable, expression);
        } else if (this.isProcedure(right) || this.isProcedure(left) && this.findImplementingOperation(right) != null) {
            this.convertFunctionType(left, right, appendable, expression);
        } else if (this.mustInsertTypeCast(context, left)) {
            this.doCastConversion(left, appendable, expression);
        } else {
            expression.exec(appendable);
        }
    }

    protected JvmOperation findImplementingOperation(LightweightTypeReference closureType) {
        return this.getTypeComputationServices().getFunctionTypes().findImplementingOperation(closureType);
    }

    protected void doCastConversion(LightweightTypeReference castTo, ITreeAppendable buffer, Later expression) {
        buffer.append("((");
        buffer.append(castTo);
        buffer.append(")");
        expression.exec(buffer);
        buffer.append(")");
    }

    private boolean isFunction(LightweightTypeReference typeReference) {
        return this.identifierStartWith(typeReference, Functions.class.getCanonicalName());
    }

    private boolean isProcedure(LightweightTypeReference typeReference) {
        return this.identifierStartWith(typeReference, Procedures.class.getCanonicalName());
    }

    private boolean identifierStartWith(LightweightTypeReference typeReference, String prefix) {
        JvmType type = typeReference.getType();
        if (type == null) {
            return false;
        }
        String identifier = type.getIdentifier();
        if (identifier != null) {
            return identifier.startsWith(prefix);
        }
        return false;
    }

    private void convertMultiType(LightweightTypeReference expectation, CompoundTypeReference multiType, XExpression context, ITreeAppendable b, Later expression) {
        LightweightTypeReference castTo = null;
        List<LightweightTypeReference> components = multiType.getMultiTypeComponents();
        ITypeReferenceOwner owner = multiType.getOwner();
        LightweightTypeReference commonType = owner.getServices().getTypeConformanceComputer().getCommonSuperType(components, owner);
        if (!this.isJavaConformant(expectation, commonType)) {
            for (LightweightTypeReference candidate : multiType.getMultiTypeComponents()) {
                if (!this.isJavaConformant(expectation, candidate)) continue;
                castTo = candidate;
                break;
            }
        }
        if (castTo != null && this.mustInsertTypeCast(context, castTo)) {
            b.append("((");
            b.append(castTo);
            b.append(")");
            expression.exec(b);
            b.append(")");
        } else {
            expression.exec(b);
        }
    }

    private void convertFunctionType(LightweightTypeReference lightweightExpectedType, LightweightTypeReference functionType, ITreeAppendable appendable, Later expression) {
        if (lightweightExpectedType.isSynonym()) {
            throw new IllegalStateException();
        }
        if (lightweightExpectedType.isType(Object.class) || lightweightExpectedType.getUniqueIdentifier().equals(functionType.getUniqueIdentifier())) {
            if (!this.isJavaConformant(lightweightExpectedType, functionType)) {
                appendable.append("(");
                appendable.append(lightweightExpectedType);
                appendable.append(")");
            }
            expression.exec(appendable);
            return;
        }
        JvmOperation operation = this.findImplementingOperation(lightweightExpectedType);
        if (operation == null) {
            throw new IllegalStateException("expected type " + String.valueOf(lightweightExpectedType) + " not mappable from " + String.valueOf(functionType));
        }
        appendable.append("new ");
        FunctionTypeReference functionTypeReference = lightweightExpectedType.tryConvertToFunctionTypeReference(false);
        if (functionTypeReference == null) {
            throw new IllegalStateException("Expected type does not seem to be a SAM type");
        }
        appendable.append(functionTypeReference.toInstanceTypeReference());
        appendable.append("() {");
        appendable.increaseIndentation().increaseIndentation();
        appendable.newLine().append("public ");
        LightweightTypeReference returnType = functionTypeReference.getReturnType();
        if (returnType == null) {
            throw new IllegalStateException("Could not find return type");
        }
        appendable.append(returnType);
        appendable.append(" ").append(operation.getSimpleName()).append("(");
        EList params = operation.getParameters();
        int i = 0;
        while (i < params.size()) {
            if (i != 0) {
                appendable.append(", ");
            }
            JvmFormalParameter p = (JvmFormalParameter)params.get(i);
            String name = p.getName();
            appendable.append(functionTypeReference.getParameterTypes().get(i));
            appendable.append(" ").append(name);
            ++i;
        }
        appendable.append(") {");
        appendable.increaseIndentation();
        try {
            appendable.openScope();
            this.reassignThisInClosure(appendable, (JvmType)operation.getDeclaringType());
            if (!(operation.getReturnType().getType() instanceof JvmVoid)) {
                appendable.newLine().append("return ");
            } else {
                appendable.newLine();
            }
            expression.exec(appendable);
            appendable.append(".");
            JvmOperation actualOperation = this.findImplementingOperation(functionType);
            appendable.append(actualOperation.getSimpleName());
            appendable.append("(");
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                JvmFormalParameter p = (JvmFormalParameter)iterator.next();
                String name = p.getName();
                appendable.append(name);
                if (!iterator.hasNext()) continue;
                appendable.append(", ");
            }
            int i2 = params.size();
            while (i2 < actualOperation.getParameters().size()) {
                if (i2 != 0) {
                    appendable.append(", ");
                }
                appendable.append("null");
                ++i2;
            }
            appendable.append(");");
        }
        finally {
            appendable.closeScope();
        }
        appendable.decreaseIndentation();
        appendable.newLine().append("}");
        appendable.decreaseIndentation().decreaseIndentation();
        appendable.newLine().append("}");
    }

    protected void reassignThisInClosure(ITreeAppendable b, JvmType rawClosureType) {
        boolean registerClosureAsThis = rawClosureType instanceof JvmGenericType;
        if (b.hasObject("this")) {
            Object element = b.getObject("this");
            if (element instanceof JvmType) {
                if (element != rawClosureType) {
                    this.doReassignThisInClosure(b, (JvmType)element);
                }
            } else {
                registerClosureAsThis = false;
            }
        }
        if (registerClosureAsThis) {
            b.declareVariable(rawClosureType, "this");
        }
    }

    protected void doReassignThisInClosure(ITreeAppendable b, JvmType prevType) {
        String proposedName = prevType.getSimpleName() + ".this";
        if (!b.hasObject(proposedName)) {
            String superVariable;
            Object superElement;
            b.declareSyntheticVariable(prevType, proposedName);
            if (b.hasObject("super") && (superElement = b.getObject("super")) instanceof JvmType && "super".equals(superVariable = b.getName(superElement))) {
                b.declareSyntheticVariable(superElement, prevType.getSimpleName() + ".super");
            }
        }
    }

    private void convertListToArray(LightweightTypeReference arrayTypeReference, ITreeAppendable appendable, Later expression) {
        appendable.append("((");
        appendable.append(arrayTypeReference);
        appendable.append(")");
        appendable.append(Conversions.class);
        appendable.append(".unwrapArray(");
        expression.exec(appendable);
        LightweightTypeReference rawTypeArrayReference = arrayTypeReference.getRawTypeReference();
        appendable.append(", ");
        appendable.append(rawTypeArrayReference.getComponentType());
        appendable.append(".class))");
    }

    private void convertArrayToList(LightweightTypeReference left, ITreeAppendable appendable, XExpression context, Later expression) {
        if (!(context.eContainer() instanceof XCastedExpression)) {
            if (context.eContainer() instanceof XAbstractFeatureCall) {
                appendable.append("((");
            } else {
                appendable.append("(");
            }
            appendable.append(left);
            appendable.append(")");
        }
        appendable.append(Conversions.class);
        appendable.append(".doWrapArray(");
        expression.exec(appendable);
        if (!(context.eContainer() instanceof XCastedExpression)) {
            if (context.eContainer() instanceof XAbstractFeatureCall) {
                appendable.append("))");
            } else {
                appendable.append(")");
            }
        } else {
            appendable.append(")");
        }
    }

    protected void convertPrimitiveToWrapper(LightweightTypeReference primitive, LightweightTypeReference wrapper, ITreeAppendable appendable, Later expression) {
        appendable.append(wrapper);
        appendable.append(".");
        appendable.append("valueOf(");
        expression.exec(appendable);
        appendable.append(")");
    }

    protected List<XExpression> normalizeBlockExpression(Collection<XExpression> expr) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)expr.size());
        for (XExpression e : expr) {
            result.add(this.normalizeBlockExpression(e));
        }
        return result;
    }

    protected XExpression normalizeBlockExpression(XExpression expr) {
        XBlockExpression block;
        if (expr instanceof XBlockExpression && (block = (XBlockExpression)expr).getExpressions().size() == 1) {
            return this.normalizeBlockExpression((XExpression)block.getExpressions().get(0));
        }
        return expr;
    }

    protected void convertWrapperToPrimitive(LightweightTypeReference wrapper, LightweightTypeReference primitive, XExpression context, ITreeAppendable appendable, Later expression) {
        JvmIdentifiableElement feature;
        XAbstractFeatureCall featureCall;
        XExpression normalized = this.normalizeBlockExpression(context);
        if (normalized instanceof XAbstractFeatureCall && !(context.eContainer() instanceof XAbstractFeatureCall) && (featureCall = (XAbstractFeatureCall)normalized).isStatic() && (feature = featureCall.getFeature()) instanceof JvmOperation && !((JvmOperation)feature).getTypeParameters().isEmpty()) {
            appendable.append("(");
            appendable.append(primitive);
            appendable.append(") ");
            expression.exec(appendable);
            return;
        }
        appendable.append("(");
        if (this.mustInsertTypeCast(context, wrapper)) {
            appendable.append("(");
            appendable.append(wrapper);
            appendable.append(") ");
        }
        expression.exec(appendable);
        appendable.append(")");
        appendable.append(".");
        appendable.append(primitive);
        appendable.append("Value()");
    }
}

