/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LaunchingUtils {
    public static void prepareBrowseFileSystemButton(@NonNull Button browseFileSystemButton, final @NonNull Text uriField, final boolean isSave) {
        final Shell shell = browseFileSystemButton.getShell();
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(shell, isSave ? 8192 : 0);
                fileDialog.open();
                String filterPath = fileDialog.getFilterPath();
                String fileName = fileDialog.getFileName();
                if (fileName != null) {
                    uriField.setText(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName)).toString());
                }
            }
        });
    }

    public static void prepareBrowseWorkspaceButton(@NonNull Button browseWorkspaceButton, final @NonNull Text uriField, final boolean isSave) {
        final Shell shell = browseWorkspaceButton.getShell();
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IFile file = null;
                if (isSave) {
                    String path = this.getContextPath();
                    ArrayList<1> filters = new ArrayList<1>();
                    filters.add(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return true;
                        }
                    });
                    file = WorkspaceResourceDialog.openNewFile((Shell)shell, null, null, (IPath)(path != null ? new Path(path) : null), filters);
                } else {
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)shell, null, null, (boolean)false, (Object[])this.getContextSelection(), null);
                    if (files.length != 0) {
                        file = files[0];
                    }
                }
                if (file != null) {
                    uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                }
            }

            private String getContextPath() {
                String text = uriField.getText();
                try {
                    URI context = text != null ? URI.createURI((String)text) : null;
                    return context != null && context.isPlatformResource() ? context.path().substring(9) : null;
                }
                catch (Exception e) {
                    return null;
                }
            }

            private Object[] getContextSelection() {
                IWorkspaceRoot root;
                IResource resource;
                String path = this.getContextPath();
                if (path != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) != null && resource.isAccessible()) {
                    return new Object[]{resource};
                }
                return null;
            }
        });
    }
}

