/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import org.eclipse.imp.ui.explorer.ExplorerMessages;
import org.eclipse.imp.ui.explorer.LayoutAction;
import org.eclipse.imp.ui.explorer.MultiActionGroup;
import org.eclipse.imp.ui.explorer.ProjectExplorerPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;

class LayoutActionGroup
extends MultiActionGroup {
    LayoutActionGroup(ProjectExplorerPart projectExplorer) {
        super(LayoutActionGroup.createActions(projectExplorer), LayoutActionGroup.getSelectedState(projectExplorer));
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.contributeToViewMenu(actionBars.getMenuManager());
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(ExplorerMessages.LayoutActionGroup_label);
        Separator marker = new Separator("layout");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    static int getSelectedState(ProjectExplorerPart projectExplorer) {
        if (projectExplorer.isFlatLayout()) {
            return 0;
        }
        return 1;
    }

    static IAction[] createActions(ProjectExplorerPart projectExplorer) {
        LayoutAction flatLayoutAction = new LayoutAction(projectExplorer, true);
        flatLayoutAction.setText(ExplorerMessages.LayoutActionGroup_flatLayoutAction_label);
        LayoutAction hierarchicalLayout = new LayoutAction(projectExplorer, false);
        hierarchicalLayout.setText(ExplorerMessages.LayoutActionGroup_hierarchicalLayoutAction_label);
        return new IAction[]{flatLayoutAction, hierarchicalLayout};
    }
}

