/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class ConstantValueWriter
extends ClassWriter.Element {
    private final int attrID;
    private int index = -1;
    private final ClassWriter w;

    public ConstantValueWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.w = w;
        this.attrID = w.addCPUtf8("ConstantValue");
    }

    public ConstantValueWriter(ClassWriter w, long v) {
        this(w);
        this.setLong(v);
    }

    public ConstantValueWriter(ClassWriter w, int v) {
        this(w);
        this.setInt(v);
    }

    public ConstantValueWriter(ClassWriter w, float v) {
        this(w);
        this.setFloat(v);
    }

    public ConstantValueWriter(ClassWriter w, double v) {
        this(w);
        this.setDouble(v);
    }

    public ConstantValueWriter(ClassWriter w, String v) {
        this(w);
        this.setString(v);
    }

    private void verify() {
        if (this.index < 0) {
            throw new IllegalArgumentException("The value's constant pool index is not set");
        }
    }

    public int getSize() {
        this.verify();
        return 8;
    }

    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        this.verify();
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, 2);
        ClassWriter.setUShort(buf, offset + 6, this.index);
        return offset + 8;
    }

    public void setLong(long value) {
        this.index = this.w.addCPLong(value);
    }

    public void setDouble(double value) {
        this.index = this.w.addCPDouble(value);
    }

    public void setInt(int value) {
        this.index = this.w.addCPInt(value);
    }

    public void setFloat(float value) {
        this.index = this.w.addCPFloat(value);
    }

    public void setString(String value) {
        this.index = this.w.addCPString(value);
    }

    public void setValueCPIndex(int index) throws IllegalArgumentException {
        if (index < 1 || index > 65535) {
            throw new IllegalArgumentException("Invalid CP index: " + index);
        }
        this.index = index;
    }
}

