/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.CodeWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LineNumberTableWriter;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableWriter;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInstrumenter {
    private final boolean[] deletedMethods;
    private final MethodData[] methods;
    private final CodeReader[] oldCode;
    private final ClassReader cr;
    private final ConstantPoolReader cpr;
    private boolean createFakeLineNumbers = false;
    private int fakeLineOffset;
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];

    public ClassInstrumenter(byte[] bytes) throws InvalidClassFileException {
        this(new ClassReader(bytes));
    }

    public void enableFakeLineNumbers(int offset) {
        this.createFakeLineNumbers = true;
        this.fakeLineOffset = offset;
    }

    public ClassInstrumenter(ClassReader cr) throws InvalidClassFileException {
        if (cr == null) {
            throw new IllegalArgumentException("cr is null");
        }
        this.cr = cr;
        this.methods = new MethodData[cr.getMethodCount()];
        this.oldCode = new CodeReader[this.methods.length];
        this.cpr = CTDecoder.makeConstantPoolReader(cr);
        this.deletedMethods = new boolean[this.methods.length];
    }

    public ClassReader getReader() {
        return this.cr;
    }

    private void prepareMethod(int i) throws InvalidClassFileException {
        if (this.deletedMethods[i]) {
            this.methods[i] = null;
        } else if (this.methods[i] == null) {
            ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
            this.cr.initMethodAttributeIterator(i, iter);
            while (iter.isValid()) {
                if (iter.getName().equals("Code")) {
                    MethodData md;
                    CodeReader code = new CodeReader(iter);
                    CTDecoder d = new CTDecoder(code, this.cpr);
                    try {
                        d.decode();
                    }
                    catch (Decoder.InvalidBytecodeException e) {
                        throw new InvalidClassFileException(code.getRawOffset(), e.getMessage());
                    }
                    this.methods[i] = md = new MethodData(d, this.cr.getMethodAccessFlags(i), CTDecoder.convertClassToType(this.cr.getName()), this.cr.getMethodName(i), this.cr.getMethodType(i));
                    this.oldCode[i] = code;
                    return;
                }
                iter.advance();
            }
        }
    }

    public void deleteMethod(int i) {
        this.deletedMethods[i] = true;
    }

    public MethodData createEmptyMethodData(String name, String sig, int access) {
        Instruction[] instructions = new Instruction[]{ReturnInstruction.make("V")};
        ExceptionHandler[][] handlers = new ExceptionHandler[instructions.length][];
        Arrays.fill((Object[])handlers, noHandlers);
        int[] i2b = new int[instructions.length];
        int i = 0;
        while (i < i2b.length) {
            i2b[i] = i;
            ++i;
        }
        MethodData md = null;
        try {
            md = new MethodData(access, Util.makeType(this.cr.getName()), name, sig, instructions, handlers, i2b);
        }
        catch (InvalidClassFileException ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public void newMethod(String name, String sig, ArrayList<Instruction> instructions, int access, ClassWriter classWriter, ClassWriter.Element rawLines) {
        if (instructions == null) {
            throw new IllegalArgumentException("instructions is null");
        }
        if (classWriter == null) {
            throw new IllegalArgumentException("classWriter is null");
        }
        Instruction[] ins = instructions.toArray(new Instruction[instructions.size()]);
        ExceptionHandler[][] handlers = new ExceptionHandler[ins.length][];
        Arrays.fill((Object[])handlers, noHandlers);
        int[] i2b = new int[ins.length];
        int i = 0;
        while (i < i2b.length) {
            i2b[i] = i;
            ++i;
        }
        MethodData md = null;
        try {
            md = new MethodData(access, Util.makeType(this.cr.getName()), name, sig, ins, handlers, i2b);
        }
        catch (InvalidClassFileException ex) {
            ex.printStackTrace();
        }
        CTCompiler compiler = CTCompiler.make(classWriter, md);
        compiler.compile();
        Compiler.Output output = compiler.getOutput();
        CodeWriter code = new CodeWriter(classWriter);
        code.setMaxStack(output.getMaxStack());
        code.setMaxLocals(output.getMaxLocals());
        code.setCode(output.getCode());
        code.setRawHandlers(output.getRawHandlers());
        ClassWriter.Element lines = null;
        if (rawLines == null) {
            int[] newLineMap = new int[instructions.size()];
            int i2 = 0;
            while (i2 < newLineMap.length) {
                newLineMap[i2] = i2;
                ++i2;
            }
            int[] rawTable = LineNumberTableWriter.makeRawTable(newLineMap);
            lines = new LineNumberTableWriter(classWriter);
            ((LineNumberTableWriter)lines).setRawTable(rawTable);
        }
        code.setAttributes(new ClassWriter.Element[]{rawLines == null ? lines : rawLines});
        ClassWriter.Element[] elements = new ClassWriter.Element[]{code};
        classWriter.addMethod(access, name, sig, elements);
    }

    public void newMethod(MethodData md, ClassWriter classWriter, ClassWriter.Element rawLines) {
        if (classWriter == null) {
            throw new IllegalArgumentException("classWriter is null");
        }
        if (md == null) {
            throw new IllegalArgumentException("md is null");
        }
        CTCompiler compiler = CTCompiler.make(classWriter, md);
        compiler.compile();
        Compiler.Output output = compiler.getOutput();
        CodeWriter code = new CodeWriter(classWriter);
        code.setMaxStack(output.getMaxStack());
        code.setMaxLocals(output.getMaxLocals());
        code.setCode(output.getCode());
        code.setRawHandlers(output.getRawHandlers());
        ClassWriter.Element lines = null;
        if (rawLines == null) {
            int[] newLineMap = new int[code.getCodeLength()];
            int i = 0;
            while (i < newLineMap.length) {
                newLineMap[i] = i;
                ++i;
            }
            int[] rawTable = LineNumberTableWriter.makeRawTable(newLineMap);
            lines = new LineNumberTableWriter(classWriter);
            ((LineNumberTableWriter)lines).setRawTable(rawTable);
        }
        code.setAttributes(new ClassWriter.Element[]{rawLines == null ? lines : rawLines});
        ClassWriter.Element[] elements = new ClassWriter.Element[]{code};
        classWriter.addMethod(md.getAccess(), md.getName(), md.getSignature(), elements);
    }

    public void visitMethods(MethodExaminer me) throws InvalidClassFileException {
        int i = 0;
        while (i < this.methods.length) {
            this.prepareMethod(i);
            if (this.methods[i] != null) {
                me.examineCode(this.methods[i]);
            }
            ++i;
        }
    }

    public MethodData visitMethod(int i) throws InvalidClassFileException {
        this.prepareMethod(i);
        return this.methods[i];
    }

    public CodeReader getMethodCode(int i) throws InvalidClassFileException {
        this.prepareMethod(i);
        return this.oldCode[i];
    }

    public void resetMethod(int i) {
        this.deletedMethods[i] = false;
        this.methods[i] = null;
    }

    public void replaceMethod(int i, MethodData md) {
        if (md == null) {
            throw new IllegalArgumentException("md is null");
        }
        this.deletedMethods[i] = false;
        this.methods[i] = md;
        this.oldCode[i] = null;
        md.setHasChanged();
    }

    public boolean isChanged() {
        int i = 0;
        while (i < this.methods.length) {
            if (this.deletedMethods[i] || this.methods[i] != null && this.methods[i].getHasChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ClassWriter emitClass() throws InvalidClassFileException {
        ClassWriter w = new ClassWriter();
        this.emitClassInto(w);
        return w;
    }

    private void emitClassInto(ClassWriter w) throws InvalidClassFileException {
        w.setMajorVersion(this.cr.getMajorVersion());
        w.setMinorVersion(this.cr.getMinorVersion());
        w.setRawCP(this.cr.getCP(), false);
        w.setAccessFlags(this.cr.getAccessFlags());
        w.setNameIndex(this.cr.getNameIndex());
        w.setSuperNameIndex(this.cr.getSuperNameIndex());
        w.setInterfaceNameIndices(this.cr.getInterfaceNameIndices());
        int fieldCount = this.cr.getFieldCount();
        int i = 0;
        while (i < fieldCount) {
            w.addRawField(new ClassWriter.RawElement(this.cr.getBytes(), this.cr.getFieldRawOffset(i), this.cr.getFieldRawSize(i)));
            ++i;
        }
        i = 0;
        while (i < this.methods.length) {
            MethodData md = this.methods[i];
            if (!this.deletedMethods[i]) {
                if (md == null || !md.getHasChanged()) {
                    w.addRawMethod(new ClassWriter.RawElement(this.cr.getBytes(), this.cr.getMethodRawOffset(i), this.cr.getMethodRawSize(i)));
                } else {
                    CTCompiler comp = CTCompiler.make(w, md);
                    comp.setPresetConstants(this.cpr);
                    try {
                        comp.compile();
                    }
                    catch (Error ex) {
                        ex.printStackTrace();
                        throw new Error("Error compiling method " + md + ": " + ex.getMessage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new Error("Error compiling method " + md + ": " + ex.getMessage());
                    }
                    CodeReader oc = this.oldCode[i];
                    int flags = this.cr.getMethodAccessFlags(i);
                    w.addMethod(flags &= 0xFFFFFEFF, this.cr.getMethodNameIndex(i), this.cr.getMethodTypeIndex(i), this.makeMethodAttributes(i, w, oc, comp.getOutput()));
                    Compiler.Output[] aux = comp.getAuxiliaryMethods();
                    if (aux != null) {
                        int j = 0;
                        while (j < aux.length) {
                            Compiler.Output a = aux[j];
                            w.addMethod(a.getAccessFlags(), a.getMethodName(), a.getMethodSignature(), this.makeMethodAttributes(i, w, oc, a));
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.cr.initClassAttributeIterator(iter);
        while (iter.isValid()) {
            w.addClassAttribute(new ClassWriter.RawElement(this.cr.getBytes(), iter.getRawOffset(), iter.getRawSize()));
            iter.advance();
        }
    }

    private static CodeWriter makeNewCode(ClassWriter w, Compiler.Output output) {
        CodeWriter code = new CodeWriter(w);
        code.setMaxStack(output.getMaxStack());
        code.setMaxLocals(output.getMaxLocals());
        code.setCode(output.getCode());
        code.setRawHandlers(output.getRawHandlers());
        return code;
    }

    private LineNumberTableWriter makeNewLines(ClassWriter w, CodeReader oldCode, Compiler.Output output) throws InvalidClassFileException {
        int[] newLineMap = null;
        int[] oldLineMap = LineNumberTableReader.makeBytecodeToSourceMap(oldCode);
        if (oldLineMap != null) {
            int[] newToOldMap = output.getNewBytecodesToOldBytecodes();
            newLineMap = new int[newToOldMap.length];
            int i = 0;
            while (i < newToOldMap.length) {
                int old = newToOldMap[i];
                if (old >= 0) {
                    newLineMap[i] = oldLineMap[old];
                }
                ++i;
            }
        } else if (this.createFakeLineNumbers) {
            newLineMap = new int[output.getCode().length];
            int i = 0;
            while (i < newLineMap.length) {
                newLineMap[i] = i + this.fakeLineOffset;
                ++i;
            }
        } else {
            return null;
        }
        int[] rawTable = LineNumberTableWriter.makeRawTable(newLineMap);
        if (rawTable == null || rawTable.length == 0) {
            return null;
        }
        LineNumberTableWriter lines = new LineNumberTableWriter(w);
        lines.setRawTable(rawTable);
        return lines;
    }

    private static LocalVariableTableWriter makeNewLocals(ClassWriter w, CodeReader oldCode, Compiler.Output output) throws InvalidClassFileException {
        int[][] oldMap = LocalVariableTableReader.makeVarMap(oldCode);
        if (oldMap != null) {
            int[] newToOldMap = output.getNewBytecodesToOldBytecodes();
            int[][] newMap = new int[newToOldMap.length][];
            int[] lastLocals = null;
            int i = 0;
            while (i < newToOldMap.length) {
                int old = newToOldMap[i];
                if (old >= 0) {
                    newMap[i] = oldMap[old];
                    lastLocals = newMap[i];
                } else {
                    newMap[i] = lastLocals;
                }
                ++i;
            }
            int[] rawTable = LocalVariableTableWriter.makeRawTable(newMap);
            if (rawTable == null || rawTable.length == 0) {
                return null;
            }
            LocalVariableTableWriter locals = new LocalVariableTableWriter(w);
            locals.setRawTable(rawTable);
            return locals;
        }
        return null;
    }

    private ClassWriter.Element[] makeMethodAttributes(int m, ClassWriter w, CodeReader oldCode, Compiler.Output output) throws InvalidClassFileException {
        CodeWriter code = ClassInstrumenter.makeNewCode(w, output);
        int codeAttrCount = 0;
        LineNumberTableWriter lines = null;
        LocalVariableTableWriter locals = null;
        if (oldCode != null) {
            lines = this.makeNewLines(w, oldCode, output);
            if (lines != null) {
                ++codeAttrCount;
            }
            if ((locals = ClassInstrumenter.makeNewLocals(w, oldCode, output)) != null) {
                ++codeAttrCount;
            }
        }
        ClassWriter.Element[] codeAttributes = new ClassWriter.Element[codeAttrCount];
        int codeAttrIndex = 0;
        if (lines != null) {
            codeAttributes[0] = lines;
            ++codeAttrIndex;
        }
        if (locals != null) {
            codeAttributes[codeAttrIndex] = locals;
        }
        code.setAttributes(codeAttributes);
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.cr.initMethodAttributeIterator(m, iter);
        int methodAttrCount = iter.getRemainingAttributesCount();
        if (oldCode == null) {
            ++methodAttrCount;
        }
        ClassWriter.Element[] methodAttributes = new ClassWriter.Element[methodAttrCount];
        int i = 0;
        while (iter.isValid()) {
            if (iter.getName().equals("Code")) {
                methodAttributes[i] = code;
                code = null;
                if (oldCode == null) {
                    throw new Error("No old code provided, but Code attribute found");
                }
            } else {
                methodAttributes[i] = new ClassWriter.RawElement(this.cr.getBytes(), iter.getRawOffset(), iter.getRawSize());
            }
            ++i;
            iter.advance();
        }
        if (oldCode == null) {
            if (code == null) {
                throw new Error("Old code not provided but existing code was found and replaced");
            }
            methodAttributes[methodAttrCount - 1] = code;
        }
        return methodAttributes;
    }

    public static interface MethodExaminer {
        public void examineCode(MethodData var1);
    }
}

