/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTuple;

public abstract class Operation
extends ASMOclAny {
    public static ASMOclType myType = new ASMOclSimpleType("Operation", Operation.getOclAnyType());

    public Operation() {
        super(myType);
    }

    public abstract String getName();

    public abstract String getContextSignature();

    public abstract ASMOclType getContextType();

    public abstract List getParameters();

    public abstract ASMOclType getReturnType();

    public abstract String getSignature();

    public abstract ASMOclAny exec(StackFrame var1);

    public ASMOclAny get(StackFrame frame, String name) {
        ASMOclAny ret = null;
        if (name.equals("parameters")) {
            List params = this.getParameters();
            if (params != null) {
                ret = new ASMSequence();
                int paramId = 1;
                Iterator i = params.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    String paramName = "p" + paramId++;
                    ASMOclAny type = new ASMOclUndefined();
                    if (o instanceof ASMParameter) {
                        ASMParameter param = (ASMParameter)o;
                        paramName = param.getName();
                    } else if (o instanceof ASMOclType) {
                        type = (ASMOclType)o;
                    }
                    ASMTuple t = new ASMTuple();
                    t.set(frame, "varName", new ASMString(paramName));
                    t.set(frame, "operation", this);
                    t.set(frame, "type", type);
                    ((ASMSequence)ret).add(t);
                }
            } else {
                ret = new ASMSequence();
            }
        } else if (name.equals("returnType")) {
            ASMOclType rt = this.getReturnType();
            ret = rt == null ? new ASMOclUndefined() : rt;
        } else if (name.equals("name")) {
            ret = new ASMString(this.getName());
        } else if (name.equals("context")) {
            ASMOclType ct = this.getContextType();
            ret = ct == null ? new ASMOclUndefined() : ct;
        } else if (name.equals("definition")) {
            ASMTuple t = new ASMTuple();
            ASMTuple t2 = new ASMTuple();
            t.set(frame, "feature", this);
            t.set(frame, "context_", t2);
            t2.set(frame, "context_", this.getContextType());
            ret = t;
        } else {
            ret = super.get(frame, name);
        }
        return ret;
    }
}

