/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclParametrizedType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;

public class ASMOrderedSet
extends ASMCollection {
    public static ASMOclType myType = ASMOclParametrizedType.getASMOclParametrizedType("OrderedSet", ASMOrderedSet.getOclAnyType(), ASMSet.myType);
    private Set s;

    public ASMOrderedSet() {
        super(myType);
        this.s = new LinkedHashSet();
    }

    public ASMOrderedSet(ASMOrderedSet init) {
        super(myType);
        this.s = new LinkedHashSet(init.s);
    }

    public ASMOrderedSet(Collection init) {
        super(myType);
        this.s = new LinkedHashSet(init);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("OrderedSet {");
        Iterator i = this.s.iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append("}");
        return ret.toString();
    }

    public void add(ASMOclAny o) {
        this.s.add(o);
    }

    public void add(Iterator i) {
        while (i.hasNext()) {
            this.add((ASMOclAny)i.next());
        }
    }

    public Iterator iterator() {
        return this.s.iterator();
    }

    public Collection collection() {
        return this.s;
    }

    public boolean equals(Object o) {
        return o instanceof ASMOrderedSet && ((ASMOrderedSet)o).s.equals(this.s);
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public static ASMOrderedSet append(StackFrame frame, ASMOrderedSet self, ASMOclAny o) {
        return ASMOrderedSet.including(frame, self, o);
    }

    public static ASMOrderedSet prepend(StackFrame frame, ASMOrderedSet self, ASMOclAny o) {
        return ASMOrderedSet.insertAt(frame, self, new ASMInteger(1), o);
    }

    public static ASMOrderedSet insertAt(StackFrame frame, ASMOrderedSet self, ASMInteger index, ASMOclAny o) {
        LinkedHashSet<ASMOclAny> ret = new LinkedHashSet<ASMOclAny>();
        int k = 0;
        int idx = index.getSymbol() - 1;
        Iterator i = self.s.iterator();
        while (i.hasNext()) {
            if (k++ == idx) {
                ret.add(o);
            }
            ret.add((ASMOclAny)i.next());
        }
        return new ASMOrderedSet(ret);
    }

    public static ASMOrderedSet subOrderedSet(StackFrame frame, ASMOrderedSet self, ASMInteger lower, ASMInteger upper) {
        ASMOrderedSet ret = new ASMOrderedSet();
        int l = lower.getSymbol();
        int u = upper.getSymbol();
        int k = 1;
        Iterator i = self.iterator();
        while (i.hasNext() && k <= u) {
            ASMOclAny object = (ASMOclAny)i.next();
            if (k >= l) {
                ret.add(object);
            }
            ++k;
        }
        return ret;
    }

    public static ASMOclAny at(StackFrame frame, ASMOrderedSet self, ASMInteger i) {
        ASMOclAny ret = null;
        int k = 0;
        int idx = i.getSymbol() - 1;
        Iterator j = self.s.iterator();
        while (j.hasNext() && ret == null) {
            if (k++ == idx) {
                ret = (ASMOclAny)j.next();
                continue;
            }
            j.next();
        }
        return ret;
    }

    public static ASMInteger indexOf(StackFrame frame, ASMOrderedSet self, ASMOclAny o) {
        int i = -2;
        int k = 1;
        Iterator j = self.s.iterator();
        while (j.hasNext() && i < 0) {
            ASMOclAny p = (ASMOclAny)j.next();
            if (o.equals(p)) {
                i = k;
            }
            ++k;
        }
        return new ASMInteger(i);
    }

    public static ASMOclAny first(StackFrame frame, ASMOrderedSet self) {
        return self.s.size() == 0 ? new ASMOclUndefined() : (ASMOclAny)self.s.iterator().next();
    }

    public static ASMOclAny last(StackFrame frame, ASMOrderedSet self) {
        ASMOclAny ret = null;
        if (self.s.size() == 0) {
            ret = new ASMOclUndefined();
        } else {
            Iterator j = self.s.iterator();
            while (j.hasNext()) {
                ret = (ASMOclAny)j.next();
            }
        }
        return ret;
    }

    public static ASMOrderedSet union(StackFrame frame, ASMOrderedSet self, ASMCollection other) {
        ASMOrderedSet ret = new ASMOrderedSet(self);
        ret.s.addAll(other.collection());
        return ret;
    }

    public static ASMOrderedSet flatten(StackFrame frame, ASMOrderedSet self) {
        ASMOrderedSet ret = new ASMOrderedSet();
        Iterator i = self.s.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ASMCollection) {
                Iterator j = ((ASMCollection)o).iterator();
                while (j.hasNext()) {
                    ret.s.add(j.next());
                }
                continue;
            }
            ret.s.add(o);
        }
        return ret;
    }

    public static ASMOrderedSet including(StackFrame frame, ASMOrderedSet self, ASMOclAny o) {
        ASMOrderedSet ret = new ASMOrderedSet(self);
        ret.s.add(o);
        return ret;
    }

    public static ASMOrderedSet excluding(StackFrame frame, ASMOrderedSet self, ASMOclAny o) {
        ASMOrderedSet ret = new ASMOrderedSet(self);
        ret.s.remove(o);
        return ret;
    }

    public static ASMSequence asSequence(StackFrame frame, ASMOrderedSet self) {
        return new ASMSequence(self.s);
    }
}

