/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.am3.core.AM3Handler;
import org.eclipse.am3.core.JarClassLoader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class AM3CorePlugin
extends AbstractUIPlugin {
    private static AM3CorePlugin plugin;
    private ResourceBundle resourceBundle;
    private JarClassLoader loader;
    private AM3Handler handler;

    public AM3CorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.am3.core.MgmPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.createLoader();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static AM3CorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AM3CorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getPluginRep() {
        try {
            URL urlPlatform = AM3CorePlugin.getDefault().getBundle().getEntry("/");
            URL localFileInPluginURL = FileLocator.toFileURL((URL)urlPlatform);
            String path = localFileInPluginURL.getPath().toString();
            return path;
        }
        catch (MalformedURLException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return null;
    }

    private void createLoader() {
        try {
            if (this.loader == null) {
                URL url = AM3CorePlugin.getDefault().getBundle().getEntry("/");
                String urlString = url.toString();
                LinkedList<URL> list = new LinkedList<URL>();
                String requires = (String)AM3CorePlugin.getDefault().getBundle().getHeaders().get("Bundle-ClassPath");
                String metaModel = String.valueOf(AM3CorePlugin.getPluginRep()) + "resources/AM3/AM3.ecore";
                String model = String.valueOf(AM3CorePlugin.getPluginRep()) + "resources/AM3/megamodel-AM3.ecore";
                this.handler = new AM3Handler(metaModel, model);
                this.handler.initASMModel();
                Set injectorElements = this.handler.getElementsByType("EBNFInjector");
                Iterator it = injectorElements.iterator();
                while (it.hasNext()) {
                    EObject eo = (EObject)it.next();
                    requires = String.valueOf(requires) + "," + this.handler.get(eo, "uri");
                }
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
                int i = 0;
                while (i < elements.length) {
                    ManifestElement element = elements[i];
                    String libPathStr = element.getValue();
                    String libUrlStr = String.valueOf(urlString) + libPathStr;
                    URL libUrl = new URL(libUrlStr);
                    list.add(libUrl);
                    ++i;
                }
                URL[] libUrls = list.toArray(new URL[list.size()]);
                this.loader = new JarClassLoader(libUrls, ((Object)((Object)this)).getClass().getClassLoader());
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    public AM3Handler getHandler() {
        return this.handler;
    }

    public JarClassLoader getLoader() {
        return this.loader;
    }
}

