/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.util.ExpressionsUtil;
import org.eclipse.emf.ocl.helper.Choice;
import org.eclipse.emf.ocl.helper.ChoiceType;
import org.eclipse.emf.ocl.helper.ConstraintType;
import org.eclipse.emf.ocl.helper.HelperUtil;
import org.eclipse.emf.ocl.helper.IOCLHelper;
import org.eclipse.emf.ocl.helper.OCLParsingException;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.internal.parser.CompatibilityUtil;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.ocl.types.PrimitiveBoolean;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.helper.ConstraintKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCLHelper
implements IOCLHelper {
    private org.eclipse.emf.ocl.parser.EnvironmentFactory environmentFactory;
    private Environment environment;

    OCLHelper(org.eclipse.emf.ocl.parser.EnvironmentFactory factory) {
        if (factory == null) {
            HelperUtil.throwException(new IllegalArgumentException("OCLHelper"), this.getClass(), "OCLHelper");
        }
        this.environmentFactory = factory;
    }

    @Override
    public org.eclipse.emf.ocl.parser.EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    public String removeOCLComments(String txt) {
        try {
            return HelperUtil.getLogicalLine(txt);
        }
        catch (Exception ex) {
            HelperUtil.catchException(ex, this.getClass(), "removeOCLComments");
            return "";
        }
    }

    @Override
    public void setContext(Object context) {
        this.environment = this.environmentFactory.createClassifierContext(context);
        this.adjustEnvironmentFactory(this.environment, this.environmentFactory);
    }

    private void adjustEnvironmentFactory(Environment env, org.eclipse.emf.ocl.parser.EnvironmentFactory factory) {
        if (env instanceof EcoreEnvironment) {
            new EcoreEnvironment.Access((EcoreEnvironment)env){

                public void setFactory(org.eclipse.emf.ocl.parser.EnvironmentFactory factory) {
                    super.setFactory(factory);
                }
            }.setFactory(factory);
        }
    }

    @Override
    public void setContextOperation(Object context, Object operation) {
        this.environment = this.environmentFactory.createOperationContext(context, operation);
        this.adjustEnvironmentFactory(this.environment, this.environmentFactory);
    }

    @Override
    public void setContextProperty(Object context, Object property) {
        this.environment = this.environmentFactory.createPropertyContext(context, property);
        this.adjustEnvironmentFactory(this.environment, this.environmentFactory);
    }

    @Override
    public EClassifier getContextClassifier() {
        return this.environment.getContextClassifier();
    }

    @Override
    public EOperation getContextOperation() {
        return this.environment.getContextOperation();
    }

    @Override
    public EStructuralFeature getContextProperty() {
        return this.environment.getContextProperty();
    }

    @Override
    @Deprecated
    public List getSyntaxHelp(String txt) {
        return this.getContextOperation() != null ? this.getSyntaxHelp(ConstraintType.POSTCONDITION, txt) : this.getSyntaxHelp(ConstraintType.INVARIANT, txt);
    }

    @Override
    public List getSyntaxHelp(ConstraintType constraintType, String txt) {
        EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory = CompatibilityUtil.getCompatibilityFactory(this.environmentFactory);
        org.eclipse.ocl.helper.OCLHelper helper = org.eclipse.ocl.internal.helper.HelperUtil.createOCLHelper((org.eclipse.ocl.OCL)OCL.newInstance(CompatibilityUtil.getCompatibilityEnvironment(null, this.environment, factory)));
        List choices = helper.getSyntaxHelp(OCLHelper.convertConstraintType(constraintType), txt);
        helper.getOCL().dispose();
        return OCLHelper.convertChoices(choices);
    }

    @Override
    public OCLExpression createQuery(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createQuery(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createQuery");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    @Override
    public OCLExpression createInvariant(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createInvariant(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createInvariant");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    @Override
    public OCLExpression createPrecondition(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createPrecondition(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createPrecondition");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    @Override
    public OCLExpression createPostcondition(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createPostcondition(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createPostcondition");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    @Override
    public OCLExpression createBodyCondition(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createBodyCondition(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createBodyCondition");
            }
        }
        return this.createNullCondition(Types.OCL_VOID);
    }

    @Override
    public OCLExpression createInitialValueExpression(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createInitialValueExpression(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createInitialValueExpression");
            }
        }
        return this.createNullCondition(Types.OCL_VOID);
    }

    @Override
    public OCLExpression createDerivedValueExpression(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createDerivedValueExpression(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createDerivedValueExpression");
            }
        }
        return this.createNullCondition(Types.OCL_VOID);
    }

    @Override
    public ETypedElement define(String defExpression) throws OCLParsingException {
        try {
            return ExpressionsUtil.define(this.environment, defExpression);
        }
        catch (Exception e) {
            this.propagate(e, "define");
            return null;
        }
    }

    @Override
    public Object evaluate(Object context, OCLExpression expr) {
        Object result = null;
        Query q = QueryFactory.eINSTANCE.createQuery(expr);
        q.setExtentMap(this.environmentFactory.createExtentMap(context));
        q.setEvaluationEnvironment(this.environmentFactory.createEvaluationEnvironment());
        result = q.evaluate(context);
        return result;
    }

    @Override
    public Object evaluate(Object context, String expr) throws OCLParsingException {
        OCLExpression ocl = null;
        try {
            ocl = ExpressionsUtil.createQuery(this.environment, expr, true);
        }
        catch (Exception e) {
            this.propagate(e, "evaluate");
        }
        return this.evaluate(context, ocl);
    }

    @Override
    public boolean check(Object context, OCLExpression constraint) {
        if (!(constraint.getType() instanceof PrimitiveBoolean)) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        Object result = this.evaluate(context, constraint);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public boolean check(Object context, String constraint) throws OCLParsingException {
        OCLExpression ocl = null;
        try {
            ocl = ExpressionsUtil.createInvariant(this.environment, constraint, true);
        }
        catch (Exception e) {
            this.propagate(e, "evaluate");
        }
        return this.check(context, ocl);
    }

    private OCLExpression createNullCondition(EClassifier type) {
        OCLExpression result;
        if (OCLHelper.isBoolean(type)) {
            BooleanLiteralExp literal;
            result = literal = ExpressionsFactory.eINSTANCE.createBooleanLiteralExp();
            literal.setType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
            literal.setBooleanSymbol(Boolean.FALSE);
        } else {
            UnspecifiedValueExp unspec = ExpressionsFactory.eINSTANCE.createUnspecifiedValueExp();
            result = unspec;
            if (type == null) {
                type = Types.OCL_VOID;
            }
            unspec.setType(type);
        }
        return result;
    }

    private static boolean isBoolean(EClassifier type) {
        boolean result = TypesPackage.eINSTANCE.getPrimitiveBoolean().isInstance((Object)type);
        if (!result && type != null) {
            Class javaClass = type.getInstanceClass();
            result = javaClass == Boolean.TYPE || javaClass == Boolean.class;
        }
        return result;
    }

    private void propagate(Exception e, String method) throws OCLParsingException {
        OCLPlugin.catching(this.getClass(), method, e);
        OCLParsingException ope = new OCLParsingException(e.getLocalizedMessage(), e);
        OCLPlugin.throwing(this.getClass(), method, ope);
        throw ope;
    }

    private static List<Choice> convertChoices(List<org.eclipse.ocl.helper.Choice> choices) {
        ArrayList<Choice> result = new ArrayList<Choice>(choices.size());
        for (org.eclipse.ocl.helper.Choice choice : choices) {
            result.add(new Choice(choice.getName(), choice.getDescription(), OCLHelper.convertKind(choice)));
        }
        return result;
    }

    private static ChoiceType convertKind(org.eclipse.ocl.helper.Choice choice) {
        switch (choice.getKind()) {
            case PROPERTY: {
                EAttribute attr;
                if (choice.getElement() instanceof EAttribute && (attr = (EAttribute)choice.getElement()).getEType() instanceof EEnum) {
                    return ChoiceType.ENUMERATION_LITERAL;
                }
                return ChoiceType.STRUCTURAL_FEATURE;
            }
            case OPERATION: 
            case SIGNAL: {
                return ChoiceType.BEHAVIORAL_FEATURE;
            }
            case VARIABLE: {
                return ChoiceType.VARIABLE;
            }
            case ENUMERATION_LITERAL: 
            case STATE: 
            case TYPE: 
            case ASSOCIATION_CLASS: 
            case PACKAGE: {
                return ChoiceType.STRUCTURAL_FEATURE;
            }
        }
        return ChoiceType.UNCATEGORIZED;
    }

    private static ConstraintKind convertConstraintType(ConstraintType kind) {
        switch (kind.getValue()) {
            case 1: {
                return ConstraintKind.PRECONDITION;
            }
            case 2: {
                return ConstraintKind.BODYCONDITION;
            }
            case 3: {
                return ConstraintKind.POSTCONDITION;
            }
        }
        return ConstraintKind.INVARIANT;
    }
}

