/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.hideshow.indicator.ColumnHideIndicatorEventMatcher;
import org.eclipse.nebula.widgets.nattable.hideshow.indicator.HierarchicalRowHideIndicatorEventMatcher;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.action.RowResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.widgets.Menu;

public class HierarchicalHideIndicatorMenuConfiguration
extends AbstractUiBindingConfiguration {
    protected ILayer columnHeaderLayer;
    protected Menu columnHideIndicatorMenu;
    protected Menu rowHideIndicatorMenu;

    public HierarchicalHideIndicatorMenuConfiguration(NatTable natTable, ILayer columnHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHideIndicatorMenu = this.createColumnHeaderMenu(natTable).build();
        this.rowHideIndicatorMenu = this.createRowHeaderMenu(natTable).build();
    }

    protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable).withMenuItemProvider(MenuItemProviders.showColumnMenuItemProvider(true, "%MenuItemProviders.showColumn", null)).withMenuItemProvider(MenuItemProviders.showAllColumnsMenuItemProvider("%MenuItemProviders.showAllColumns", null));
    }

    protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable).withMenuItemProvider(MenuItemProviders.showRowMenuItemProvider(true, "%MenuItemProviders.showRow", null)).withMenuItemProvider(MenuItemProviders.showAllRowsMenuItemProvider("%MenuItemProviders.showAllRows", null));
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        if (this.columnHideIndicatorMenu != null) {
            uiBindingRegistry.registerFirstMouseMoveBinding(new ColumnHideIndicatorEventMatcher(0, "COLUMN_HEADER", 0, this.columnHeaderLayer), new ColumnResizeCursorAction(), new ClearCursorAction());
            uiBindingRegistry.registerFirstMouseDownBinding(new ColumnHideIndicatorEventMatcher(0, "COLUMN_HEADER", 3, this.columnHeaderLayer), new PopupMenuAction(this.columnHideIndicatorMenu));
        }
        if (this.rowHideIndicatorMenu != null) {
            uiBindingRegistry.registerFirstMouseMoveBinding(new HierarchicalRowHideIndicatorEventMatcher(0, 0), new RowResizeCursorAction(), new ClearCursorAction());
            uiBindingRegistry.registerFirstMouseDownBinding(new HierarchicalRowHideIndicatorEventMatcher(0, 3), new PopupMenuAction(this.rowHideIndicatorMenu));
        }
    }
}

