/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.config;

import org.eclipse.nebula.widgets.nattable.config.AbstractLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnGroupExpandCollapseAction;
import org.eclipse.nebula.widgets.nattable.group.action.UngroupColumnsAction;
import org.eclipse.nebula.widgets.nattable.group.action.ViewportSelectColumnGroupAction;
import org.eclipse.nebula.widgets.nattable.group.painter.ColumnGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.action.ColumnGroupHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.performance.action.ColumnHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.performance.action.CreateColumnGroupAction;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.SWT;

public class DefaultColumnGroupHeaderLayerConfiguration
extends AbstractLayerConfiguration<ColumnGroupHeaderLayer> {
    private final boolean enableColumnGroupSelectionBinding;
    private final boolean enableExpandCollapseBinding;
    private ColumnGroupHeaderLayer columnGroupHeaderLayer;

    public DefaultColumnGroupHeaderLayerConfiguration(boolean enableGroupSelection) {
        this(enableGroupSelection, true);
    }

    public DefaultColumnGroupHeaderLayerConfiguration(boolean enableGroupSelection, boolean enableExpandCollapse) {
        this.enableColumnGroupSelectionBinding = enableGroupSelection;
        this.enableExpandCollapseBinding = enableExpandCollapse;
    }

    @Override
    public void configureTypedLayer(ColumnGroupHeaderLayer layer) {
        this.columnGroupHeaderLayer = layer;
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BeveledBorderDecorator(new ColumnGroupHeaderTextPainter()), DisplayMode.NORMAL, "COLUMN_GROUP_HEADER");
        if (this.columnGroupHeaderLayer.isShowAlwaysGroupNames()) {
            Style headerStyle = new Style();
            headerStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, HorizontalAlignmentEnum.LEFT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, headerStyle, DisplayMode.NORMAL, "COLUMN_GROUP_HEADER");
        }
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnGroupHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new ColumnGroupHeaderReorderDragMode(this.columnGroupHeaderLayer)));
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new ColumnHeaderReorderDragMode(this.columnGroupHeaderLayer)));
        if (!this.enableColumnGroupSelectionBinding) {
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new NoOpMouseAction());
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1), new NoOpMouseAction());
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD2), new NoOpMouseAction());
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1 | SWT.MOD2), new NoOpMouseAction());
        } else {
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ViewportSelectColumnGroupAction(false, false));
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1), new ViewportSelectColumnGroupAction(false, true));
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD2), new ViewportSelectColumnGroupAction(true, false));
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1 | SWT.MOD2), new ViewportSelectColumnGroupAction(true, true));
        }
        if (this.enableExpandCollapseBinding) {
            uiBindingRegistry.registerDoubleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ColumnGroupExpandCollapseAction(this.enableColumnGroupSelectionBinding));
        }
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 103), new CreateColumnGroupAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 117), new UngroupColumnsAction());
    }
}

