/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public final class FillHandleLayerPainterHelper {
    private FillHandleLayerPainterHelper() {
    }

    public static BorderStyle getHandleRegionBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, DisplayMode.NORMAL, new String[0]);
        if (borderStyle == null) {
            borderStyle = new BorderStyle(2, GUIHelper.getColor(0, 125, 10), BorderStyle.LineStyleEnum.SOLID, BorderStyle.BorderModeEnum.INTERNAL);
        }
        return borderStyle;
    }

    public static Color getHandleColor(IConfigRegistry configRegistry) {
        Color color;
        if (configRegistry != null && (color = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, DisplayMode.NORMAL, new String[0])) != null) {
            return color;
        }
        return GUIHelper.getColor(0, 125, 10);
    }

    public static BorderStyle getHandleBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        if (configRegistry != null && (borderStyle = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, DisplayMode.NORMAL, new String[0])) != null) {
            return borderStyle;
        }
        return new BorderStyle(1, GUIHelper.COLOR_WHITE, BorderStyle.LineStyleEnum.SOLID, BorderStyle.BorderModeEnum.CENTERED);
    }

    public static BorderStyle getCopyBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "copyBorderStyle");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            borderStyle = new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DASHED, BorderStyle.BorderModeEnum.CENTERED);
        }
        return borderStyle;
    }

    public static Point getHandleSize(IConfigRegistry configRegistry) {
        Point size;
        if (configRegistry != null && (size = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_SIZE, DisplayMode.NORMAL, new String[0])) != null) {
            return size;
        }
        return new Point(7, 7);
    }
}

