/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.command;

import java.util.List;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.command.RowObjectDeleteCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowObjectDeleteEvent;

public class RowObjectDeleteCommandHandler<T>
implements ILayerCommandHandler<RowObjectDeleteCommand> {
    private List<T> bodyData;

    public RowObjectDeleteCommandHandler(List<T> bodyData) {
        this.bodyData = bodyData;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, RowObjectDeleteCommand command) {
        int[] indexes = new int[command.getObjectsToDelete().size()];
        int idx = 0;
        TreeMap deleted = new TreeMap();
        for (Object rowObject : command.getObjectsToDelete()) {
            int index = this.bodyData.indexOf(rowObject);
            deleted.put(index, rowObject);
            indexes[idx] = index;
            ++idx;
        }
        this.bodyData.removeAll(command.getObjectsToDelete());
        targetLayer.fireLayerEvent(new RowObjectDeleteEvent(targetLayer, deleted));
        return true;
    }

    @Override
    public Class<RowObjectDeleteCommand> getCommandClass() {
        return RowObjectDeleteCommand.class;
    }
}

