/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers.EncapsulatedAdapterFactoryLabelProvider;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractNewDecoratorModelPage;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ExternalizeProfileApplicationsPage
extends AbstractNewDecoratorModelPage<Package, ProfileApplication> {
    public ExternalizeProfileApplicationsPage() {
        super("externalize", Messages.ExternalizeProfileApplicationsPage_0, null, ProfileApplication.class);
        this.setMessage(Messages.ExternalizeProfileApplicationsPage_1);
    }

    @Override
    protected void browseResource() {
        this.browseResource(Messages.ExternalizeProfileApplicationsPage_2, Messages.ExternalizeProfileApplicationsPage_3);
    }

    @Override
    protected IBaseLabelProvider createProfilesLabelProvider() {
        return EncapsulatedAdapterFactoryLabelProvider.appliedProfiles();
    }

    @Override
    protected IStructuredContentProvider createProfilesContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] result = null;
                if (inputElement instanceof Package) {
                    Package package_ = (Package)inputElement;
                    ArrayList profileApplications = Lists.newArrayList();
                    for (ProfileApplication next : package_.getProfileApplications()) {
                        Profile profile = next.getAppliedProfile();
                        if (profile == null || profile.eIsProxy()) continue;
                        profileApplications.add(next);
                    }
                    result = profileApplications.toArray();
                }
                return result == null ? new Object[]{} : result;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    @Override
    protected String validateExistingFile(IFile file) {
        String result = null;
        String conflictingProfile = null;
        if (!DecoratorModelUtils.isDecoratorModel((URI)this.getResourceURI())) {
            result = Messages.ExternalizeProfileApplicationsPage_4;
        } else {
            conflictingProfile = this.findProfileApplication(file);
            if (conflictingProfile != null) {
                result = NLS.bind((String)Messages.ExternalizeProfileApplicationsPage_5, (Object)conflictingProfile, (Object)((Package)this.getInput()).getName());
            }
        }
        return result;
    }

    private String findProfileApplication(IFile decoratorModel) {
        URI decoratorModelURI = URI.createPlatformResourceURI((String)decoratorModel.getFullPath().toString(), (boolean)true);
        String result = null;
        try {
            Set applied = DecoratorModelIndex.getInstance().getAppliedProfiles(EcoreUtil.getURI((EObject)((EObject)this.getInput())), decoratorModelURI);
            for (ProfileApplication profileApplication : this.getSelectedProfileApplications()) {
                if (!applied.contains(EcoreUtil.getURI((EObject)profileApplication.getAppliedProfile()))) continue;
                result = profileApplication.getAppliedProfile().getName();
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return result;
    }

    @Override
    protected String defaultResource(Package package_) {
        String result;
        Object resourceName;
        Object object = resourceName = package_ == null ? "" : UML2Util.getValidJavaIdentifier((String)package_.getName());
        if (((String)resourceName).length() > 0 && Character.isUpperCase(((String)resourceName).charAt(0))) {
            resourceName = Character.toLowerCase(((String)resourceName).charAt(0)) + ((String)resourceName).substring(1);
        }
        if (package_ == null || package_.eResource() == null) {
            result = resourceName;
        } else {
            IPath path = new Path(package_.eResource().getURI().toPlatformString(true)).removeLastSegments(1).append((String)resourceName).addFileExtension(this.getFileExtension());
            result = path.toString();
        }
        return result;
    }
}

