/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.api.actions;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public final class EclipseCommandToAction
extends Action {
    private Command wrappedCommand;

    public EclipseCommandToAction(String commandId) {
        this.wrappedCommand = this.getCommand(commandId);
    }

    public boolean isEnabled() {
        if (this.wrappedCommand != null) {
            return this.wrappedCommand.isEnabled();
        }
        return false;
    }

    public boolean isHandled() {
        if (this.wrappedCommand != null) {
            return this.wrappedCommand.isHandled();
        }
        return false;
    }

    protected final Command getCommand(String commandId) {
        IWorkbenchWindow activeWorkbench;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbench = workbench.getActiveWorkbenchWindow()) != null && activeWorkbench.getService(ICommandService.class) != null) {
            ICommandService service = (ICommandService)activeWorkbench.getService(ICommandService.class);
            return service.getCommand(commandId);
        }
        return null;
    }

    public void run() {
        if (this.wrappedCommand != null && this.wrappedCommand.isHandled()) {
            try {
                this.wrappedCommand.executeWithChecks(new ExecutionEvent());
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                Activator.log.error(e);
            }
        }
    }
}

