/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.impl.Preconditions;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public final class SetMatcherEditor<E, O>
extends AbstractMatcherEditor<E> {
    private static final Logger L = Logger.getLogger(SetMatcherEditor.class.toString());
    private final FunctionList.Function<E, O> function;
    private Mode mode;

    public static <E, O> SetMatcherEditor<E, O> create(Mode mode, FunctionList.Function<E, O> fn) {
        return new SetMatcherEditor<E, O>(mode, fn);
    }

    private SetMatcherEditor(Mode mode, FunctionList.Function<E, O> function) {
        this.function = Preconditions.checkNotNull(function);
        this.mode = Preconditions.checkNotNull(mode);
        Preconditions.checkState(this.isCurrentlyMatchingAll());
        if (mode == Mode.WHITELIST_EMPTY_MATCH_NONE) {
            this.fireMatchNone();
        }
    }

    public void setMatchSet(Set<O> newSet) {
        Preconditions.checkNotNull(newSet);
        Set oldSet = this.getMatcher() instanceof SetMatcher ? ((SetMatcher)this.getMatcher()).matchSet : new HashSet();
        if (oldSet.equals(newSet)) {
            L.fine("new set equals old -> no change to filter");
        } else if (newSet.isEmpty()) {
            if (this.mode == Mode.WHITELIST_EMPTY_MATCH_NONE) {
                L.fine("empty set (" + (Object)((Object)this.mode) + ") -> firing matchNone");
                this.fireMatchNone();
            } else {
                L.fine("empty set (" + (Object)((Object)this.mode) + ") -> firing matchAll");
                this.fireMatchAll();
            }
        } else if (oldSet.isEmpty()) {
            L.fine("old set was empty, new set is not -> firing change");
            this.fireChanged(new SetMatcher(newSet, this.mode, this.function));
        } else if (oldSet.containsAll(newSet)) {
            if (this.mode == Mode.BLACKLIST) {
                L.fine("old set contains new set (blacklist) -> firing relaxed");
                this.fireRelaxed(new SetMatcher(newSet, this.mode, this.function));
            } else {
                L.fine("old set contains new set (whitelist) -> firing constrained");
                this.fireConstrained(new SetMatcher(newSet, this.mode, this.function));
            }
        } else if (newSet.containsAll(oldSet)) {
            if (this.mode == Mode.BLACKLIST) {
                L.fine("new set contains old set (blacklist) -> firing constrained");
                this.fireConstrained(new SetMatcher(newSet, this.mode, this.function));
            } else {
                L.fine("new set contains old set (whitelist) -> firing relaxed");
                this.fireRelaxed(new SetMatcher(newSet, this.mode, this.function));
            }
        } else {
            L.fine("old and new set differ -> firing change");
            this.fireChanged(new SetMatcher(newSet, this.mode, this.function));
        }
    }

    private static final class SetMatcher<E, O>
    implements Matcher<E> {
        private final Set<O> matchSet;
        private final FunctionList.Function<E, O> fn;
        private final Mode mode;

        private SetMatcher(Set<O> matchSet, Mode mode, FunctionList.Function<E, O> fn) {
            this.matchSet = new HashSet<O>(matchSet);
            this.mode = mode;
            this.fn = Preconditions.checkNotNull(fn);
        }

        @Override
        public boolean matches(E input) {
            boolean result = this.matchSet.contains(this.fn.evaluate(input));
            return this.mode == Mode.BLACKLIST ? !result : result;
        }
    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST_EMPTY_MATCH_NONE,
        WHITELIST_EMPTY_MATCH_ALL;

    }
}

