/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.snap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

public class NodeSnapHelper {
    protected final boolean snapOnCorners;
    protected final boolean snapOnMiddles;
    protected final boolean snapOnCenter;
    private SnapToHelper helper;
    private Rectangle figureToSnapBounds;
    private Rectangle compoundSourceRectangle;

    public NodeSnapHelper(SnapToHelper helper, Rectangle figureToSnapBounds) {
        this(helper, figureToSnapBounds, figureToSnapBounds);
    }

    public NodeSnapHelper(SnapToHelper helper, Rectangle figureToSnapBounds, Rectangle compoundSourceRectangle) {
        this(helper, figureToSnapBounds, compoundSourceRectangle, true, false, false);
    }

    public NodeSnapHelper(SnapToHelper helper, Rectangle figureToSnapBounds, boolean snapOnCorners, boolean snapOnMiddles, boolean snapOnCenter) {
        this(helper, figureToSnapBounds, figureToSnapBounds, snapOnCorners, snapOnMiddles, snapOnCenter);
    }

    public NodeSnapHelper(SnapToHelper helper, Rectangle figureToSnapBounds, Rectangle compoundSourceRectangle, boolean snapOnCorners, boolean snapOnMiddles, boolean snapOnCenter) {
        this.helper = helper;
        this.figureToSnapBounds = figureToSnapBounds;
        this.compoundSourceRectangle = compoundSourceRectangle;
        this.snapOnCorners = snapOnCorners;
        this.snapOnMiddles = snapOnMiddles;
        this.snapOnCenter = snapOnCenter;
    }

    public void snapPoint(ChangeBoundsRequest request) {
        if (this.getSnapToHelper() != null && request.isSnapToEnabled()) {
            ArrayList distances;
            int restrictedDirection = 0;
            restrictedDirection |= 0x10;
            restrictedDirection |= 8;
            restrictedDirection |= 4;
            request.getExtendedData().put("org.eclipse.gmf.runtime.diagram.ui.RestrictedDirections", restrictedDirection |= 1);
            HashMap<Double, PrecisionPoint> distVSPoint = new HashMap<Double, PrecisionPoint>();
            if (this.snapOnCorners) {
                distVSPoint.putAll(this.getCornerDistances(request));
            }
            if (this.snapOnMiddles) {
                distVSPoint.putAll(this.getMiddleDistances(request));
            }
            if (this.snapOnCenter) {
                distVSPoint.putAll(this.getCenterDistances(request));
            }
            if ((distances = new ArrayList(distVSPoint.keySet())).size() > 0) {
                double min = (Double)distances.get(0);
                int i = 1;
                while (i < distances.size() - 1) {
                    min = Math.min(min, (Double)distances.get(i));
                    ++i;
                }
                request.setMoveDelta((Point)distVSPoint.get(min));
            }
        }
    }

    protected final int getRestrictedDirection(ChangeBoundsRequest request) {
        int restrictedDirection = 0;
        Point delta = request.getMoveDelta();
        if (delta.x > 0) {
            restrictedDirection |= 0x10;
            restrictedDirection |= 8;
        }
        if (delta.x < 0) {
            restrictedDirection |= 0x10;
            restrictedDirection |= 8;
        }
        if (delta.y > 0) {
            restrictedDirection |= 4;
            restrictedDirection |= 1;
        }
        if (delta.y < 0) {
            restrictedDirection |= 4;
            restrictedDirection |= 1;
        }
        return restrictedDirection;
    }

    protected void calculateSnapPointFromArrowKey(ChangeBoundsRequest request) {
        if (request.getEditParts().size() == 0) {
            return;
        }
        Object ep = request.getEditParts().get(0);
        if (!(ep instanceof IGraphicalEditPart)) {
            return;
        }
        RootEditPart root = ((IGraphicalEditPart)ep).getRoot();
        if (!(root instanceof DiagramRootEditPart)) {
            return;
        }
        double gridSpacing = ((DiagramRootEditPart)root).getGridSpacing();
        int max = (int)(1.0 + gridSpacing);
        int restrictedDirection = this.getRestrictedDirection(request);
        Point delta = request.getMoveDelta();
        Point newDelta = new Point(0, 0);
        int newMove = 0;
        while (newMove < max) {
            ArrayList distances;
            ++newMove;
            if (delta.x > 0) {
                newDelta.x = newMove + delta.x;
            }
            if (delta.x < 0) {
                newDelta.x = -newMove + delta.x;
            }
            if (delta.y > 0) {
                newDelta.y = newMove + delta.y;
            }
            if (delta.y < 0) {
                newDelta.y = -newMove + delta.y;
            }
            request.setMoveDelta(newDelta);
            request.getExtendedData().put("org.eclipse.gmf.runtime.diagram.ui.RestrictedDirections", restrictedDirection);
            HashMap<Double, PrecisionPoint> distVSPoint = new HashMap<Double, PrecisionPoint>();
            if (this.snapOnCorners) {
                distVSPoint.putAll(this.getCornerDistances(request));
            }
            if (this.snapOnMiddles) {
                distVSPoint.putAll(this.getMiddleDistances(request));
            }
            if (this.snapOnCenter) {
                distVSPoint.putAll(this.getCenterDistances(request));
            }
            if ((distances = new ArrayList(distVSPoint.keySet())).size() <= 0) continue;
            double min = (Double)distances.get(0);
            int i = 1;
            while (i < distances.size() - 1) {
                min = Math.min(min, (Double)distances.get(i));
                ++i;
            }
            Point minPoint = (Point)distVSPoint.get(min);
            if (minPoint.x == 0 && minPoint.y == 0 || Integer.signum(minPoint.x) != Integer.signum(delta.x) || Integer.signum(minPoint.y) != Integer.signum(delta.y)) continue;
            request.setMoveDelta((Point)distVSPoint.get(min));
            return;
        }
    }

    protected Map<Double, PrecisionPoint> getCornerDistances(ChangeBoundsRequest request) {
        HashMap<Double, PrecisionPoint> distVSPoints = new HashMap<Double, PrecisionPoint>();
        if (this.getSnapToHelper() != null && request.isSnapToEnabled()) {
            Point moveDelta = request.getMoveDelta();
            PrecisionRectangle jointRect = this.getCompoundSourceRectangle();
            jointRect.translate(moveDelta);
            PrecisionPoint topLeftCornerDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectTopLeft = this.getSourceRectangle();
            baseRectTopLeft.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectTopLeft, jointRect}, topLeftCornerDelta);
            PrecisionPoint topRightCornerDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectTopRight = this.getSourceRectangle();
            baseRectTopRight.setX(baseRectTopRight.x + baseRectTopRight.width);
            baseRectTopRight.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectTopRight, jointRect}, topRightCornerDelta);
            PrecisionPoint bottomLeftCornerDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectBottomLeft = this.getSourceRectangle();
            baseRectBottomLeft.setY(baseRectBottomLeft.y + baseRectBottomLeft.height);
            baseRectBottomLeft.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectBottomLeft, jointRect}, bottomLeftCornerDelta);
            PrecisionPoint bottomRightCornerDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectBottomRight = this.getSourceRectangle();
            baseRectBottomRight.setX(baseRectBottomRight.x + baseRectBottomRight.width);
            baseRectBottomRight.setY(baseRectBottomRight.y + baseRectBottomRight.height);
            baseRectBottomRight.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectBottomRight, jointRect}, bottomRightCornerDelta);
            Point ref = baseRectTopLeft.getTopLeft();
            distVSPoints.put(this.distance(ref, (Point)topLeftCornerDelta), topLeftCornerDelta);
        }
        return distVSPoints;
    }

    protected Map<Double, PrecisionPoint> getMiddleDistances(ChangeBoundsRequest request) {
        HashMap<Double, PrecisionPoint> distVSPoints = new HashMap<Double, PrecisionPoint>();
        if (this.getSnapToHelper() != null && request.isSnapToEnabled()) {
            Point moveDelta = request.getMoveDelta();
            PrecisionRectangle jointRect = this.getCompoundSourceRectangle();
            jointRect.translate(moveDelta);
            PrecisionPoint middleTopDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectMiddleTop = this.getSourceRectangle();
            baseRectMiddleTop.setPreciseLocation(baseRectMiddleTop.preciseX() + baseRectMiddleTop.preciseWidth() / 2.0, baseRectMiddleTop.preciseY());
            baseRectMiddleTop.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectMiddleTop, jointRect}, middleTopDelta);
            PrecisionPoint middleLeftDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectMiddleLeft = this.getSourceRectangle();
            baseRectMiddleLeft.setPreciseLocation(baseRectMiddleLeft.preciseX(), baseRectMiddleLeft.preciseY() + baseRectMiddleLeft.preciseWidth() / 2.0);
            baseRectMiddleLeft.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectMiddleLeft, jointRect}, middleLeftDelta);
            PrecisionPoint middleRightDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectMiddleRight = this.getSourceRectangle();
            baseRectMiddleRight.setPreciseLocation(baseRectMiddleRight.preciseX() + baseRectMiddleRight.preciseWidth(), baseRectMiddleRight.preciseY() + baseRectMiddleRight.preciseHeight() / 2.0);
            baseRectMiddleRight.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectMiddleRight, jointRect}, middleRightDelta);
            PrecisionPoint middleBottomDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectMiddleBottom = this.getSourceRectangle();
            baseRectMiddleBottom.setPreciseLocation(baseRectMiddleBottom.preciseX() + baseRectMiddleBottom.preciseWidth() / 2.0, baseRectMiddleBottom.preciseY() + baseRectMiddleBottom.preciseHeight());
            baseRectMiddleBottom.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectMiddleBottom, jointRect}, middleBottomDelta);
            Point ref = baseRectMiddleTop.getTopLeft();
            distVSPoints.put(this.distance(ref, (Point)middleTopDelta), middleTopDelta);
            distVSPoints.put(this.distance(ref, (Point)middleLeftDelta), middleLeftDelta);
            distVSPoints.put(this.distance(ref, (Point)middleRightDelta), middleRightDelta);
            distVSPoints.put(this.distance(ref, (Point)middleBottomDelta), middleBottomDelta);
        }
        return distVSPoints;
    }

    protected Map<Double, PrecisionPoint> getCenterDistances(ChangeBoundsRequest request) {
        HashMap<Double, PrecisionPoint> distVSPoints = new HashMap<Double, PrecisionPoint>();
        if (this.getSnapToHelper() != null && request.isSnapToEnabled()) {
            Point moveDelta = request.getMoveDelta();
            PrecisionRectangle jointRect = this.getCompoundSourceRectangle();
            jointRect.translate(moveDelta);
            PrecisionPoint centerDelta = new PrecisionPoint(moveDelta);
            PrecisionRectangle baseRectCenter = this.getSourceRectangle();
            baseRectCenter.setPreciseLocation(baseRectCenter.preciseX() + baseRectCenter.preciseWidth() / 2.0, baseRectCenter.preciseY() + baseRectCenter.preciseHeight() / 2.0);
            baseRectCenter.translate(moveDelta);
            this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRectCenter, jointRect}, centerDelta);
            Point ref = baseRectCenter.getTopLeft();
            distVSPoints.put(this.distance(ref, (Point)centerDelta), centerDelta);
        }
        return distVSPoints;
    }

    private PrecisionRectangle getCompoundSourceRectangle() {
        return new PrecisionRectangle(this.compoundSourceRectangle);
    }

    private PrecisionRectangle getSourceRectangle() {
        return new PrecisionRectangle(this.figureToSnapBounds);
    }

    protected final double distance(Point pt1, Point pt2) {
        double deltaX = pt1.preciseX() - pt2.preciseX();
        double deltaY = pt1.preciseY() - pt2.preciseY();
        return Math.hypot(deltaX, deltaY);
    }

    protected final SnapToHelper getSnapToHelper() {
        return this.helper;
    }
}

