/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class CustomStyleListener
extends AdapterImpl {
    private final Collection<String> styleNames;
    private final IChangeListener listener;
    private boolean disposed;
    private final EStructuralFeature listenedFeature;

    public CustomStyleListener(View source, EStructuralFeature listenedFeature, IChangeListener listener, String styleName) {
        this(source, listenedFeature, listener, Collections.singleton(styleName));
    }

    public CustomStyleListener(View source, IChangeListener listener, Collection<String> styleNames) {
        this(source, null, listener, styleNames);
    }

    public CustomStyleListener(View source, EStructuralFeature listenedFeature, IChangeListener listener, Collection<String> styleNames) {
        this.styleNames = styleNames;
        this.listener = listener;
        this.listenedFeature = listenedFeature;
        for (Object styleObject : source.getStyles()) {
            NamedStyle style;
            if (!(styleObject instanceof NamedStyle) || !styleNames.contains((style = (NamedStyle)styleObject).getName())) continue;
            style.eAdapters().add((Object)this);
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.disposed) {
            ((Notifier)notification.getNotifier()).eAdapters().remove((Object)this);
            return;
        }
        if (notification.getFeature() == NotationPackage.eINSTANCE.getView_Styles()) {
            switch (notification.getEventType()) {
                case 3: {
                    this.handleAdd((EObject)notification.getNewValue());
                    break;
                }
                case 5: {
                    for (Object object : (List)notification.getNewValue()) {
                        this.handleAdd((EObject)object);
                    }
                    break;
                }
                case 4: {
                    this.handleRemove((EObject)notification.getOldValue());
                    break;
                }
                case 6: {
                    for (Object object : (List)notification.getOldValue()) {
                        this.handleRemove((EObject)object);
                    }
                    break;
                }
            }
            return;
        }
        if (!(notification.getFeature() != this.listenedFeature && this.listenedFeature != null || notification.isTouch())) {
            this.handleChange(notification.getNotifier());
        }
    }

    private void handleRemove(EObject oldValue) {
        oldValue.eAdapters().remove((Object)this);
        this.handleChange(oldValue);
    }

    private void handleAdd(EObject newValue) {
        newValue.eAdapters().add((Object)this);
        this.handleChange(newValue);
    }

    private void handleChange(Object value) {
        if (value instanceof NamedStyle && this.styleNames.contains(((NamedStyle)value).getName())) {
            this.listener.handleChange(null);
        }
    }

    public void dispose() {
        this.disposed = true;
    }
}

