/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.papyrus.infra.tools.Activator;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class ClasspathHelper {
    public static final ClasspathHelper INSTANCE;

    static {
        ClasspathHelper instance;
        try {
            instance = new JDTHelper();
        }
        catch (Exception e) {
            instance = new ClasspathHelper();
        }
        INSTANCE = instance;
    }

    public Object findClass(String name, URI context, Class<?> constraint) {
        return constraint == null ? ClassLoaderHelper.loadClass(name, context) : ClassLoaderHelper.loadClass(name, constraint, context);
    }

    private static final class JDTHelper
    extends ClasspathHelper {
        private JDTHelper() {
        }

        @Override
        public Object findClass(String name, URI context, Class<?> constraint) {
            Object result = null;
            IJavaProject project = this.getJavaProject(context);
            if (project == null) {
                if (context == null) {
                    result = this.searchType(name, constraint);
                }
                if (result == null) {
                    result = super.findClass(name, context, constraint);
                }
            } else {
                result = this.findType(project, name, constraint);
            }
            if (result == null) {
                result = this.searchType(name, constraint);
            }
            return result;
        }

        private IJavaProject getJavaProject(URI context) {
            IJavaProject result = null;
            if (context != null && (context.isPlatformResource() || context.isPlatformPlugin())) {
                String projectName = context.segment(1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project.isAccessible()) {
                    result = JavaCore.create((IProject)project);
                }
            }
            return result;
        }

        IType findType(IJavaProject project, String name, Class<?> constraint) {
            IType result;
            try {
                result = project.findType(JDTHelper.jdtQualifiedName(name));
                if (result != null && constraint != null && !this.conformsTo(result, constraint)) {
                    result = null;
                }
            }
            catch (JavaModelException e) {
                Activator.log.error("Failed to find Java type on the project classpath.", (Throwable)e);
                result = null;
            }
            return result;
        }

        private static String jdtQualifiedName(String qualifiedName) {
            return qualifiedName.replace('$', '.');
        }

        private IType searchType(String name, final Class<?> constraint) {
            SearchEngine search = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((String)JDTHelper.jdtQualifiedName(name), (int)0, (int)0, (int)8);
            final IType[] result = new IType[1];
            NullProgressMonitor monitor = new NullProgressMonitor();
            SearchRequestor requestor = new SearchRequestor((IProgressMonitor)monitor){
                private final /* synthetic */ IProgressMonitor val$monitor;
                {
                    this.val$monitor = iProgressMonitor;
                }

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match.getElement() instanceof IType) {
                        IType foundType = (IType)match.getElement();
                        if (constraint == null || this.conformsTo(foundType, constraint)) {
                            result[0] = foundType;
                            this.val$monitor.setCanceled(true);
                        }
                    }
                }
            };
            try {
                search.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), requestor, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                Activator.log.error("Failed to find Java type on the workspace classpath.", (Throwable)e);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
            return result[0];
        }

        private boolean conformsTo(IType type, Class<?> supertype) {
            boolean result = false;
            try {
                ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                result = Stream.of(hierarchy.getAllSupertypes(type)).map(t -> t.getFullyQualifiedName('$')).anyMatch(supertype.getCanonicalName()::equals);
            }
            catch (JavaModelException e) {
                Activator.log.error("Failed to find Java type on the workspace classpath.", (Throwable)e);
            }
            return result;
        }
    }
}

