/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;

public interface DiagnosticEquivalence {
    public static final DiagnosticEquivalence DEFAULT = new DiagnosticEquivalence(){

        @Override
        public int hashCode(Diagnostic diagnostic) {
            return Objects.hash(diagnostic.getSource(), diagnostic.getSeverity(), diagnostic.getCode(), diagnostic.getMessage(), diagnostic.getData(), diagnostic.getChildren());
        }

        @Override
        public boolean equals(Diagnostic diagnostic1, Diagnostic diagnostic2) {
            return Objects.equals(diagnostic1.getSource(), diagnostic2.getSource()) && diagnostic1.getSeverity() == diagnostic2.getSeverity() && diagnostic1.getCode() == diagnostic2.getCode() && Objects.equals(diagnostic1.getMessage(), diagnostic2.getMessage()) && Objects.equals(diagnostic1.getData(), diagnostic2.getData()) && Objects.equals(diagnostic1.getChildren(), diagnostic2.getChildren());
        }
    };

    public int hashCode(Diagnostic var1);

    public boolean equals(Diagnostic var1, Diagnostic var2);

    default public Diagnostic wrap(Diagnostic diagnostic, Object ... additionalData) {
        class DiagnosticWrapper
        implements Diagnostic {
            private final Diagnostic delegate;
            private final List<Diagnostic> children;
            private final List<?> data;
            private final /* synthetic */ Object[] val$additionalData;

            DiagnosticWrapper(Diagnostic delegate, Object[] objectArray) {
                List originalData;
                this.val$additionalData = objectArray;
                this.delegate = delegate;
                this.children = delegate.getChildren().stream().map(child -> DiagnosticEquivalence.this.wrap((Diagnostic)child, objectArray)).collect(Collectors.toList());
                List list = originalData = delegate.getData() == null ? Collections.emptyList() : delegate.getData();
                if (objectArray.length > 0) {
                    ArrayList toAdd = Lists.newArrayList((Object[])objectArray);
                    toAdd.removeAll(originalData);
                    ArrayList copy = new ArrayList(originalData);
                    copy.addAll(toAdd);
                    this.data = Collections.unmodifiableList(copy);
                } else {
                    this.data = Collections.unmodifiableList(originalData);
                }
            }

            public List<Diagnostic> getChildren() {
                return this.children;
            }

            public int hashCode() {
                return DiagnosticEquivalence.this.hashCode(this);
            }

            public boolean equals(Object obj) {
                return obj instanceof Diagnostic && DiagnosticEquivalence.this.equals(this, (Diagnostic)obj);
            }

            public List<?> getData() {
                return this.data;
            }

            public int getSeverity() {
                return this.delegate.getSeverity();
            }

            public String getMessage() {
                return this.delegate.getMessage();
            }

            public String getSource() {
                return this.delegate.getSource();
            }

            public int getCode() {
                return this.delegate.getCode();
            }

            public Throwable getException() {
                return this.delegate.getException();
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                switch (this.getSeverity()) {
                    case 0: {
                        result.append("OK");
                        break;
                    }
                    case 1: {
                        result.append("Info");
                        break;
                    }
                    case 2: {
                        result.append("Warning");
                        break;
                    }
                    case 8: {
                        result.append("Cancel");
                        break;
                    }
                    default: {
                        result.append("Error");
                    }
                }
                result.append('(');
                result.append(this.getSource()).append(", ");
                result.append(this.getCode()).append(", ");
                result.append(this.getData());
                result.append("): ");
                result.append(this.getMessage());
                return result.toString();
            }
        }
        return diagnostic instanceof DiagnosticWrapper ? diagnostic : new DiagnosticWrapper(diagnostic, additionalData);
    }
}

