/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditorConfiguration;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RichTextEditorCompositeWrapper
extends Composite {
    protected ViewForm form;
    protected RichTextEditor richTextEditor;

    public RichTextEditorCompositeWrapper(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.init(this);
    }

    protected void init(Composite parent) {
        try {
            this.form = new ViewForm(parent, 0x800800);
            this.form.marginHeight = 0;
            this.form.marginWidth = 0;
            GridData gridData = new GridData(768);
            gridData.heightHint = 350;
            gridData.widthHint = 600;
            this.form.setLayoutData((Object)gridData);
            Composite richTextComposite = this.createRichTextComposite((Composite)this.form, 2048);
            this.form.setContent((Control)richTextComposite);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public Control getControl() {
        return this.form;
    }

    public RichTextEditor getRichTextControl() {
        return this.richTextEditor;
    }

    public String getText() {
        if (this.richTextEditor != null) {
            try {
                return this.richTextEditor.getText();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public void setText(String text) {
        if (this.richTextEditor != null) {
            this.richTextEditor.setText(text);
        }
    }

    public Object getData(String key) {
        if (this.richTextEditor != null) {
            return this.richTextEditor.getData(key);
        }
        return null;
    }

    public void setData(String key, Object value) {
        if (this.richTextEditor != null) {
            this.richTextEditor.setData(key, value);
        }
    }

    public void disposeEditor() {
        if (this.richTextEditor != null) {
            this.richTextEditor.dispose();
            this.richTextEditor = null;
        }
    }

    public boolean isEditorDisposed() {
        if (this.richTextEditor != null) {
            return this.richTextEditor.isDisposed();
        }
        return true;
    }

    public void addKeyListener(KeyListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.removeKeyListener(listener);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.addModifyListener(listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.removeModifyListener(listener);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.addDisposeListener(listener);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.removeDisposeListener(listener);
        }
    }

    public void addFocusListener(FocusListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.addFocusListener(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.removeFocusListener(listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (this.richTextEditor != null) {
            this.richTextEditor.removeListener(eventType, listener);
        }
    }

    protected Composite createRichTextComposite(Composite parent, int style) {
        Composite richTextComposite = new Composite(parent, 0x800400);
        FillLayout richTextCompositeLayout = new FillLayout();
        richTextComposite.setLayout((Layout)richTextCompositeLayout);
        this.richTextEditor = this.createRichTextEditor(richTextComposite, 0x800400);
        return richTextComposite;
    }

    protected RichTextEditor createRichTextEditor(Composite composite, int style) {
        return new GenericRichTextEditor(composite, new GenericRichTextEditorConfiguration(), 0x800400);
    }

    public void dispose() {
        if (this.richTextEditor != null) {
            this.richTextEditor.dispose();
            this.richTextEditor = null;
        }
    }
}

